import logging, pytest, sys

from pathlib import Path
sys.path.append(__file__.split('src')[0] + 'src')
print(sys.path)

from context.client.ContextClient import ContextClient
from context.database.Factory import get_database, DatabaseEngineEnum
from context.proto.context_pb2 import Empty
from context.service.ContextService import ContextService
from context.Config import SERVICE_PORT, MAX_WORKERS, GRACE_PERIOD
from context.tests.tools.ValidateTopology import validate_topology_dict

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def local_context_service():
    database = get_database(engine=DatabaseEngineEnum.INMEMORY, filepath='data/topo_nsfnet.json')
    _service = ContextService(database, port=SERVICE_PORT, max_workers=MAX_WORKERS, grace_period=GRACE_PERIOD)
    _service.start()
    yield _service
    _service.stop()

@pytest.fixture(scope='session')
def local_context_client(local_context_service):
    return ContextClient(address='127.0.0.1', port=SERVICE_PORT)

def test_local_get_topology(local_context_client):
    response = local_context_client.GetTopology(Empty())
    validate_topology_dict(response)
