from enum import Enum

class OperationalStatus(Enum):
    ENABLED = 1
    DISABLED = 0

TO_ENUM = {
    1: OperationalStatus.ENABLED,
    0: OperationalStatus.DISABLED,
    '1': OperationalStatus.ENABLED,
    '0': OperationalStatus.DISABLED,
    'enabled': OperationalStatus.ENABLED,
    'disabled': OperationalStatus.DISABLED,
}

def to_operationalstatus_enum(int_or_str):
    if isinstance(int_or_str, str): int_or_str = int_or_str.lower()
    return TO_ENUM.get(int_or_str)
