# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class geolocation(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/geolocation. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains a GPS location.
  """
  __slots__ = ('_path_helper', '_extmethods', '__altitude','__latitude','__longitude',)

  _yang_name = 'geolocation'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__altitude = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="altitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int64', is_config=False)
    self.__latitude = YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-90..90']}), is_leaf=True, yang_name="latitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)
    self.__longitude = YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-180..180']}), is_leaf=True, yang_name="longitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'geolocation']

  def _get_altitude(self):
    """
    Getter method for altitude, mapped from YANG variable /networks/network/node/te/geolocation/altitude (int64)

    YANG Description: Distance above sea level.
    """
    return self.__altitude
      
  def _set_altitude(self, v, load=False):
    """
    Setter method for altitude, mapped from YANG variable /networks/network/node/te/geolocation/altitude (int64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_altitude is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_altitude() directly.

    YANG Description: Distance above sea level.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="altitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """altitude must be of a type compatible with int64""",
          'defined-type': "int64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="altitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int64', is_config=False)""",
        })

    self.__altitude = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_altitude(self):
    self.__altitude = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="altitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='int64', is_config=False)


  def _get_latitude(self):
    """
    Getter method for latitude, mapped from YANG variable /networks/network/node/te/geolocation/latitude (geographic-coordinate-degree)

    YANG Description: Relative position north or south on the Earth's surface.
    """
    return self.__latitude
      
  def _set_latitude(self, v, load=False):
    """
    Setter method for latitude, mapped from YANG variable /networks/network/node/te/geolocation/latitude (geographic-coordinate-degree)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_latitude is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_latitude() directly.

    YANG Description: Relative position north or south on the Earth's surface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-90..90']}), is_leaf=True, yang_name="latitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """latitude must be of a type compatible with geographic-coordinate-degree""",
          'defined-type': "ietf-te-topology:geographic-coordinate-degree",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-90..90']}), is_leaf=True, yang_name="latitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)""",
        })

    self.__latitude = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_latitude(self):
    self.__latitude = YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-90..90']}), is_leaf=True, yang_name="latitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)


  def _get_longitude(self):
    """
    Getter method for longitude, mapped from YANG variable /networks/network/node/te/geolocation/longitude (geographic-coordinate-degree)

    YANG Description: Angular distance east or west on the Earth's surface.
    """
    return self.__longitude
      
  def _set_longitude(self, v, load=False):
    """
    Setter method for longitude, mapped from YANG variable /networks/network/node/te/geolocation/longitude (geographic-coordinate-degree)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_longitude is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_longitude() directly.

    YANG Description: Angular distance east or west on the Earth's surface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-180..180']}), is_leaf=True, yang_name="longitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """longitude must be of a type compatible with geographic-coordinate-degree""",
          'defined-type': "ietf-te-topology:geographic-coordinate-degree",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-180..180']}), is_leaf=True, yang_name="longitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)""",
        })

    self.__longitude = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_longitude(self):
    self.__longitude = YANGDynClass(base=RestrictedClassType(base_type=RestrictedPrecisionDecimalType(precision=8), restriction_dict={'range': ['-180..180']}), is_leaf=True, yang_name="longitude", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='geographic-coordinate-degree', is_config=False)

  altitude = __builtin__.property(_get_altitude)
  latitude = __builtin__.property(_get_latitude)
  longitude = __builtin__.property(_get_longitude)


  _pyangbind_elements = OrderedDict([('altitude', altitude), ('latitude', latitude), ('longitude', longitude), ])


