# coding: utf-8

import sys
from setuptools import setup, find_packages

NAME = "tapi_server"
VERSION = "2.1.3"
# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = [
    "connexion",
    "swagger-ui-bundle>=0.0.2"
]

setup(
    name=NAME,
    version=VERSION,
    description="tapi-notification,tapi-connectivity,tapi-topology,tapi-common,tapi-path-computation API",
    author_email="",
    url="",
    keywords=["Swagger", "tapi-notification,tapi-connectivity,tapi-topology,tapi-common,tapi-path-computation API"],
    install_requires=REQUIRES,
    packages=find_packages(),
    package_data={'': ['swagger/swagger.yaml']},
    include_package_data=True,
    entry_points={
        'console_scripts': ['tapi_server=tapi_server.__main__:main']},
    long_description="""\
              This module contains TAPI Notification Model definitions.          Source: TapiNotification.uml          - The TAPI YANG models included in this TAPI release are a *normative* part of the TAPI SDK.          - The YANG specifications have been generated from the corresponding UML model using the [ONF EAGLE UML2YANG mapping tool]            &lt;https://urldefense.com/v3/__https://github.com/OpenNetworkingFoundation/EagleUmlYang__;!!OSsGDw!d_dJlNtYLmD585It0DKukzB2TS5KZqBZQ-pdI1D-6c6c5hRDotd6G4QHf0bG$ &gt;            and further edited manually to comply with the [ONF IISOMI UML2YANG mapping guidelines]            &lt;https://urldefense.com/v3/__https://wiki.opennetworking.org/display/OIMT/UML*-*YANG*Guidelines__;Kysr!!OSsGDw!d_dJlNtYLmD585It0DKukzB2TS5KZqBZQ-pdI1D-6c6c5hRDotd6G8IIivez$ &gt;          - Status of YANG model artifacts can be determined by referring to the corresponding UML artifacts.            As described in the UML models, some artifacts are considered *experimental*, and thus the corresponding YANG artifacts.          - The ONF TAPI release process does not guarantee backward compatibility of YANG models across major versions of TAPI releases.            The YANG model backward compatibility criteria are outlined in section 11 of &lt;https://urldefense.com/v3/__https://tools.ietf.org/html/rfc7950__;!!OSsGDw!d_dJlNtYLmD585It0DKukzB2TS5KZqBZQ-pdI1D-6c6c5hRDotd6G3bKxRf2$ &gt;.            YANG models included in this release may not be backward compatible with previous TAPI releases.          Copyright (c) 2018 Open Networking Foundation (ONF). All rights reserved.          License: This module is distributed under the Apache License 2.0,          This module contains TAPI Connectivity Model definitions.          Source: TapiConnectivity.uml          - The TAPI YANG models included in this TAPI release are a *normative* part of the TAPI SDK.          - The YANG specifications have been generated from the corresponding UML model using the [ONF EAGLE UML2YANG mapping tool]          &lt;https://urldefense.com/v3/__https://github.com/OpenNetworkingFoundation/EagleUmlYang__;!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_6pxiNxl$ &gt;          and further edited manually to comply with the [ONF IISOMI UML2YANG mapping guidelines]          &lt;https://urldefense.com/v3/__https://wiki.opennetworking.org/display/OIMT/UML*-*YANG*Guidelines__;Kysr!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_wxKUbJ_$ &gt;          - Status of YANG model artifacts can be determined by referring to the corresponding UML artifacts.          As described in the UML models, some artifacts are considered *experimental*, and thus the corresponding YANG artifacts.          - The ONF TAPI release process does not guarantee backward compatibility of YANG models across major versions of TAPI releases.          The YANG model backward compatibility criteria are outlined in section 11 of &lt;https://urldefense.com/v3/__https://tools.ietf.org/html/rfc7950__;!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_zcAY1P4$ &gt;.          YANG models included in this release may not be backward compatible with previous TAPI releases.          Copyright (c) 2018 Open Networking Foundation (ONF). All rights reserved.          License: This module is distributed under the Apache License 2.0.,          This module contains TAPI Topology Model definitions.          Source: TapiTopology.uml          - The TAPI YANG models included in this TAPI release are a *normative* part of the TAPI SDK.          - The YANG specifications have been generated from the corresponding UML model using the [ONF EAGLE UML2YANG mapping tool]            &lt;https://urldefense.com/v3/__https://github.com/OpenNetworkingFoundation/EagleUmlYang__;!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_6pxiNxl$ &gt;            and further edited manually to comply with the [ONF IISOMI UML2YANG mapping guidelines]            &lt;https://urldefense.com/v3/__https://wiki.opennetworking.org/display/OIMT/UML*-*YANG*Guidelines__;Kysr!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_wxKUbJ_$ &gt;          - Status of YANG model artifacts can be determined by referring to the corresponding UML artifacts.            As described in the UML models, some artifacts are considered *experimental*, and thus the corresponding YANG artifacts.          - The ONF TAPI release process does not guarantee backward compatibility of YANG models across major versions of TAPI releases.            The YANG model backward compatibility criteria are outlined in section 11 of &lt;https://urldefense.com/v3/__https://tools.ietf.org/html/rfc7950__;!!OSsGDw!bx-l35NqfQHpJ8R_DmXfi2NX2ll5dMl9VbK5aS_m3ZShiVoz74Ur_zcAY1P4$ &gt;.            YANG models included in this release may not be backward compatible with previous TAPI releases.          Copyright (c) 2018 Open Networking Foundation (ONF). All rights reserved.          License: This module is distributed under the Apache License 2.0.,          This module contains TAPI Common Model definitions.          Source: TapiCommon.uml          - The TAPI YANG models included in this TAPI release are a *normative* part of the TAPI SDK.          - The YANG specifications have been generated from the corresponding UML model using the [ONF EAGLE UML2YANG mapping tool]          &lt;https://github.com/OpenNetworkingFoundation/EagleUmlYang&gt;          and further edited manually to comply with the [ONF IISOMI UML2YANG mapping guidelines]          &lt;https://wiki.opennetworking.org/display/OIMT/UML+-+YANG+Guidelines&gt;          - Status of YANG model artifacts can be determined by referring to the corresponding UML artifacts.          As described in the UML models, some artifacts are considered *experimental*, and thus the corresponding YANG artifacts.          - The ONF TAPI release process does not guarantee backward compatibility of YANG models across major versions of TAPI releases.          The YANG model backward compatibility criteria are outlined in section 11 of &lt;https://tools.ietf.org/html/rfc7950&gt;.          YANG models included in this release may not be backward compatible with previous TAPI releases.          Copyright (c) 2018 Open Networking Foundation (ONF). All rights reserved.          License: This module is distributed under the Apache License 2.0.,          This module contains TAPI Path Computation Model definitions.          Source: TapiPathComputation.uml          - The TAPI YANG models included in this TAPI release are a *normative* part of the TAPI SDK.          - The YANG specifications have been generated from the corresponding UML model using the [ONF EAGLE UML2YANG mapping tool]          &lt;https://github.com/OpenNetworkingFoundation/EagleUmlYang&gt;          and further edited manually to comply with the [ONF IISOMI UML2YANG mapping guidelines]          &lt;https://wiki.opennetworking.org/display/OIMT/UML+-+YANG+Guidelines&gt;          - Status of YANG model artifacts can be determined by referring to the corresponding UML artifacts.          As described in the UML models, some artifacts are considered *experimental*, and thus the corresponding YANG artifacts.          - The ONF TAPI release process does not guarantee backward compatibility of YANG models across major versions of TAPI releases.          The YANG model backward compatibility criteria are outlined in section 11 of &lt;https://tools.ietf.org/html/rfc7950&gt;.          YANG models included in this release may not be backward compatible with previous TAPI releases.          Copyright (c) 2018 Open Networking Foundation (ONF). All rights reserved.          License: This module is distributed under the Apache License 2.0.
    """
)
