# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import config
from . import state
from . import properties
from . import subcomponents
from . import chassis
from . import port
from . import power_supply
from . import fan
from . import fabric
from . import storage
from . import cpu
from . import integrated_circuit
from . import backplane
from . import software_module
from . import controller_card
class component(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of components, keyed by component name.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__properties','__subcomponents','__chassis','__port','__power_supply','__fan','__fabric','__storage','__cpu','__integrated_circuit','__backplane','__software_module','__controller_card',)

  _yang_name = 'component'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__properties = YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__subcomponents = YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__chassis = YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__port = YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__power_supply = YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__fan = YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__fabric = YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__storage = YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__cpu = YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__integrated_circuit = YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__backplane = YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__software_module = YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__controller_card = YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/name (leafref)

    YANG Description: References the component name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: References the component name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/config (container)

    YANG Description: Configuration data for each component
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/state (container)

    YANG Description: Operational state data for each component
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_properties(self):
    """
    Getter method for properties, mapped from YANG variable /components/component/properties (container)

    YANG Description: Enclosing container 
    """
    return self.__properties
      
  def _set_properties(self, v, load=False):
    """
    Setter method for properties, mapped from YANG variable /components/component/properties (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_properties is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_properties() directly.

    YANG Description: Enclosing container 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """properties must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__properties = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_properties(self):
    self.__properties = YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_subcomponents(self):
    """
    Getter method for subcomponents, mapped from YANG variable /components/component/subcomponents (container)

    YANG Description: Enclosing container for subcomponent references
    """
    return self.__subcomponents
      
  def _set_subcomponents(self, v, load=False):
    """
    Setter method for subcomponents, mapped from YANG variable /components/component/subcomponents (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subcomponents is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subcomponents() directly.

    YANG Description: Enclosing container for subcomponent references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subcomponents must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__subcomponents = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subcomponents(self):
    self.__subcomponents = YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_chassis(self):
    """
    Getter method for chassis, mapped from YANG variable /components/component/chassis (container)

    YANG Description: Data for chassis components
    """
    return self.__chassis
      
  def _set_chassis(self, v, load=False):
    """
    Setter method for chassis, mapped from YANG variable /components/component/chassis (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis() directly.

    YANG Description: Data for chassis components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__chassis = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis(self):
    self.__chassis = YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /components/component/port (container)

    YANG Description: Data for physical port components
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /components/component/port (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: Data for physical port components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_power_supply(self):
    """
    Getter method for power_supply, mapped from YANG variable /components/component/power_supply (container)

    YANG Description: Data for power supply components
    """
    return self.__power_supply
      
  def _set_power_supply(self, v, load=False):
    """
    Setter method for power_supply, mapped from YANG variable /components/component/power_supply (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_power_supply is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_power_supply() directly.

    YANG Description: Data for power supply components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """power_supply must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__power_supply = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_power_supply(self):
    self.__power_supply = YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_fan(self):
    """
    Getter method for fan, mapped from YANG variable /components/component/fan (container)

    YANG Description: Data for fan components
    """
    return self.__fan
      
  def _set_fan(self, v, load=False):
    """
    Setter method for fan, mapped from YANG variable /components/component/fan (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fan() directly.

    YANG Description: Data for fan components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fan must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__fan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fan(self):
    self.__fan = YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_fabric(self):
    """
    Getter method for fabric, mapped from YANG variable /components/component/fabric (container)

    YANG Description: Data for fabric components
    """
    return self.__fabric
      
  def _set_fabric(self, v, load=False):
    """
    Setter method for fabric, mapped from YANG variable /components/component/fabric (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fabric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fabric() directly.

    YANG Description: Data for fabric components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fabric must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__fabric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fabric(self):
    self.__fabric = YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_storage(self):
    """
    Getter method for storage, mapped from YANG variable /components/component/storage (container)

    YANG Description: Data for storage components
    """
    return self.__storage
      
  def _set_storage(self, v, load=False):
    """
    Setter method for storage, mapped from YANG variable /components/component/storage (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_storage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_storage() directly.

    YANG Description: Data for storage components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """storage must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__storage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_storage(self):
    self.__storage = YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /components/component/cpu (container)

    YANG Description: Data for cpu components
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /components/component/cpu (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: Data for cpu components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_integrated_circuit(self):
    """
    Getter method for integrated_circuit, mapped from YANG variable /components/component/integrated_circuit (container)

    YANG Description: Data for chip components, such as ASIC, NPUs, etc.
    """
    return self.__integrated_circuit
      
  def _set_integrated_circuit(self, v, load=False):
    """
    Setter method for integrated_circuit, mapped from YANG variable /components/component/integrated_circuit (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_integrated_circuit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_integrated_circuit() directly.

    YANG Description: Data for chip components, such as ASIC, NPUs, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """integrated_circuit must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__integrated_circuit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_integrated_circuit(self):
    self.__integrated_circuit = YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_backplane(self):
    """
    Getter method for backplane, mapped from YANG variable /components/component/backplane (container)

    YANG Description: Data for backplane components
    """
    return self.__backplane
      
  def _set_backplane(self, v, load=False):
    """
    Setter method for backplane, mapped from YANG variable /components/component/backplane (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backplane is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backplane() directly.

    YANG Description: Data for backplane components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backplane must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__backplane = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backplane(self):
    self.__backplane = YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_software_module(self):
    """
    Getter method for software_module, mapped from YANG variable /components/component/software_module (container)

    YANG Description: Data for software module components, i.e., for components
with type=SOFTWARE_MODULE
    """
    return self.__software_module
      
  def _set_software_module(self, v, load=False):
    """
    Setter method for software_module, mapped from YANG variable /components/component/software_module (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_module() directly.

    YANG Description: Data for software module components, i.e., for components
with type=SOFTWARE_MODULE
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_module must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__software_module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_module(self):
    self.__software_module = YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_controller_card(self):
    """
    Getter method for controller_card, mapped from YANG variable /components/component/controller_card (container)

    YANG Description: Data for controller card components, i.e., for components
with type=CONTROLLER_CARD
    """
    return self.__controller_card
      
  def _set_controller_card(self, v, load=False):
    """
    Setter method for controller_card, mapped from YANG variable /components/component/controller_card (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_controller_card is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_controller_card() directly.

    YANG Description: Data for controller card components, i.e., for components
with type=CONTROLLER_CARD
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """controller_card must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__controller_card = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_controller_card(self):
    self.__controller_card = YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  properties = __builtin__.property(_get_properties, _set_properties)
  subcomponents = __builtin__.property(_get_subcomponents, _set_subcomponents)
  chassis = __builtin__.property(_get_chassis, _set_chassis)
  port = __builtin__.property(_get_port, _set_port)
  power_supply = __builtin__.property(_get_power_supply, _set_power_supply)
  fan = __builtin__.property(_get_fan, _set_fan)
  fabric = __builtin__.property(_get_fabric, _set_fabric)
  storage = __builtin__.property(_get_storage, _set_storage)
  cpu = __builtin__.property(_get_cpu, _set_cpu)
  integrated_circuit = __builtin__.property(_get_integrated_circuit, _set_integrated_circuit)
  backplane = __builtin__.property(_get_backplane, _set_backplane)
  software_module = __builtin__.property(_get_software_module, _set_software_module)
  controller_card = __builtin__.property(_get_controller_card, _set_controller_card)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('properties', properties), ('subcomponents', subcomponents), ('chassis', chassis), ('port', port), ('power_supply', power_supply), ('fan', fan), ('fabric', fabric), ('storage', storage), ('cpu', cpu), ('integrated_circuit', integrated_circuit), ('backplane', backplane), ('software_module', software_module), ('controller_card', controller_card), ])


from . import config
from . import state
from . import properties
from . import subcomponents
from . import chassis
from . import port
from . import power_supply
from . import fan
from . import fabric
from . import storage
from . import cpu
from . import integrated_circuit
from . import backplane
from . import software_module
from . import controller_card
class component(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of components, keyed by component name.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__properties','__subcomponents','__chassis','__port','__power_supply','__fan','__fabric','__storage','__cpu','__integrated_circuit','__backplane','__software_module','__controller_card',)

  _yang_name = 'component'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__properties = YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__subcomponents = YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__chassis = YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__port = YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__power_supply = YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__fan = YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__fabric = YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__storage = YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__cpu = YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__integrated_circuit = YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__backplane = YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__software_module = YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    self.__controller_card = YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /components/component/name (leafref)

    YANG Description: References the component name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /components/component/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: References the component name
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /components/component/config (container)

    YANG Description: Configuration data for each component
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /components/component/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=config.config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /components/component/state (container)

    YANG Description: Operational state data for each component
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /components/component/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for each component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=state.state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_properties(self):
    """
    Getter method for properties, mapped from YANG variable /components/component/properties (container)

    YANG Description: Enclosing container 
    """
    return self.__properties
      
  def _set_properties(self, v, load=False):
    """
    Setter method for properties, mapped from YANG variable /components/component/properties (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_properties is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_properties() directly.

    YANG Description: Enclosing container 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """properties must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__properties = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_properties(self):
    self.__properties = YANGDynClass(base=properties.properties, is_container='container', yang_name="properties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_subcomponents(self):
    """
    Getter method for subcomponents, mapped from YANG variable /components/component/subcomponents (container)

    YANG Description: Enclosing container for subcomponent references
    """
    return self.__subcomponents
      
  def _set_subcomponents(self, v, load=False):
    """
    Setter method for subcomponents, mapped from YANG variable /components/component/subcomponents (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subcomponents is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subcomponents() directly.

    YANG Description: Enclosing container for subcomponent references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subcomponents must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__subcomponents = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subcomponents(self):
    self.__subcomponents = YANGDynClass(base=subcomponents.subcomponents, is_container='container', yang_name="subcomponents", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_chassis(self):
    """
    Getter method for chassis, mapped from YANG variable /components/component/chassis (container)

    YANG Description: Data for chassis components
    """
    return self.__chassis
      
  def _set_chassis(self, v, load=False):
    """
    Setter method for chassis, mapped from YANG variable /components/component/chassis (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis() directly.

    YANG Description: Data for chassis components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__chassis = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis(self):
    self.__chassis = YANGDynClass(base=chassis.chassis, is_container='container', yang_name="chassis", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_port(self):
    """
    Getter method for port, mapped from YANG variable /components/component/port (container)

    YANG Description: Data for physical port components
    """
    return self.__port
      
  def _set_port(self, v, load=False):
    """
    Setter method for port, mapped from YANG variable /components/component/port (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port() directly.

    YANG Description: Data for physical port components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port(self):
    self.__port = YANGDynClass(base=port.port, is_container='container', yang_name="port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_power_supply(self):
    """
    Getter method for power_supply, mapped from YANG variable /components/component/power_supply (container)

    YANG Description: Data for power supply components
    """
    return self.__power_supply
      
  def _set_power_supply(self, v, load=False):
    """
    Setter method for power_supply, mapped from YANG variable /components/component/power_supply (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_power_supply is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_power_supply() directly.

    YANG Description: Data for power supply components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """power_supply must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__power_supply = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_power_supply(self):
    self.__power_supply = YANGDynClass(base=power_supply.power_supply, is_container='container', yang_name="power-supply", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_fan(self):
    """
    Getter method for fan, mapped from YANG variable /components/component/fan (container)

    YANG Description: Data for fan components
    """
    return self.__fan
      
  def _set_fan(self, v, load=False):
    """
    Setter method for fan, mapped from YANG variable /components/component/fan (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fan() directly.

    YANG Description: Data for fan components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fan must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__fan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fan(self):
    self.__fan = YANGDynClass(base=fan.fan, is_container='container', yang_name="fan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_fabric(self):
    """
    Getter method for fabric, mapped from YANG variable /components/component/fabric (container)

    YANG Description: Data for fabric components
    """
    return self.__fabric
      
  def _set_fabric(self, v, load=False):
    """
    Setter method for fabric, mapped from YANG variable /components/component/fabric (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fabric is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fabric() directly.

    YANG Description: Data for fabric components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fabric must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__fabric = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fabric(self):
    self.__fabric = YANGDynClass(base=fabric.fabric, is_container='container', yang_name="fabric", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_storage(self):
    """
    Getter method for storage, mapped from YANG variable /components/component/storage (container)

    YANG Description: Data for storage components
    """
    return self.__storage
      
  def _set_storage(self, v, load=False):
    """
    Setter method for storage, mapped from YANG variable /components/component/storage (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_storage is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_storage() directly.

    YANG Description: Data for storage components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """storage must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__storage = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_storage(self):
    self.__storage = YANGDynClass(base=storage.storage, is_container='container', yang_name="storage", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_cpu(self):
    """
    Getter method for cpu, mapped from YANG variable /components/component/cpu (container)

    YANG Description: Data for cpu components
    """
    return self.__cpu
      
  def _set_cpu(self, v, load=False):
    """
    Setter method for cpu, mapped from YANG variable /components/component/cpu (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cpu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cpu() directly.

    YANG Description: Data for cpu components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cpu must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__cpu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cpu(self):
    self.__cpu = YANGDynClass(base=cpu.cpu, is_container='container', yang_name="cpu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_integrated_circuit(self):
    """
    Getter method for integrated_circuit, mapped from YANG variable /components/component/integrated_circuit (container)

    YANG Description: Data for chip components, such as ASIC, NPUs, etc.
    """
    return self.__integrated_circuit
      
  def _set_integrated_circuit(self, v, load=False):
    """
    Setter method for integrated_circuit, mapped from YANG variable /components/component/integrated_circuit (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_integrated_circuit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_integrated_circuit() directly.

    YANG Description: Data for chip components, such as ASIC, NPUs, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """integrated_circuit must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__integrated_circuit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_integrated_circuit(self):
    self.__integrated_circuit = YANGDynClass(base=integrated_circuit.integrated_circuit, is_container='container', yang_name="integrated-circuit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_backplane(self):
    """
    Getter method for backplane, mapped from YANG variable /components/component/backplane (container)

    YANG Description: Data for backplane components
    """
    return self.__backplane
      
  def _set_backplane(self, v, load=False):
    """
    Setter method for backplane, mapped from YANG variable /components/component/backplane (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backplane is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backplane() directly.

    YANG Description: Data for backplane components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backplane must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__backplane = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backplane(self):
    self.__backplane = YANGDynClass(base=backplane.backplane, is_container='container', yang_name="backplane", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_software_module(self):
    """
    Getter method for software_module, mapped from YANG variable /components/component/software_module (container)

    YANG Description: Data for software module components, i.e., for components
with type=SOFTWARE_MODULE
    """
    return self.__software_module
      
  def _set_software_module(self, v, load=False):
    """
    Setter method for software_module, mapped from YANG variable /components/component/software_module (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_software_module is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_software_module() directly.

    YANG Description: Data for software module components, i.e., for components
with type=SOFTWARE_MODULE
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """software_module must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__software_module = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_software_module(self):
    self.__software_module = YANGDynClass(base=software_module.software_module, is_container='container', yang_name="software-module", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)


  def _get_controller_card(self):
    """
    Getter method for controller_card, mapped from YANG variable /components/component/controller_card (container)

    YANG Description: Data for controller card components, i.e., for components
with type=CONTROLLER_CARD
    """
    return self.__controller_card
      
  def _set_controller_card(self, v, load=False):
    """
    Setter method for controller_card, mapped from YANG variable /components/component/controller_card (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_controller_card is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_controller_card() directly.

    YANG Description: Data for controller card components, i.e., for components
with type=CONTROLLER_CARD
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """controller_card must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)""",
        })

    self.__controller_card = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_controller_card(self):
    self.__controller_card = YANGDynClass(base=controller_card.controller_card, is_container='container', yang_name="controller-card", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/platform', defining_module='openconfig-platform', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  properties = __builtin__.property(_get_properties, _set_properties)
  subcomponents = __builtin__.property(_get_subcomponents, _set_subcomponents)
  chassis = __builtin__.property(_get_chassis, _set_chassis)
  port = __builtin__.property(_get_port, _set_port)
  power_supply = __builtin__.property(_get_power_supply, _set_power_supply)
  fan = __builtin__.property(_get_fan, _set_fan)
  fabric = __builtin__.property(_get_fabric, _set_fabric)
  storage = __builtin__.property(_get_storage, _set_storage)
  cpu = __builtin__.property(_get_cpu, _set_cpu)
  integrated_circuit = __builtin__.property(_get_integrated_circuit, _set_integrated_circuit)
  backplane = __builtin__.property(_get_backplane, _set_backplane)
  software_module = __builtin__.property(_get_software_module, _set_software_module)
  controller_card = __builtin__.property(_get_controller_card, _set_controller_card)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ('properties', properties), ('subcomponents', subcomponents), ('chassis', chassis), ('port', port), ('power_supply', power_supply), ('fan', fan), ('fabric', fabric), ('storage', storage), ('cpu', cpu), ('integrated_circuit', integrated_circuit), ('backplane', backplane), ('software_module', software_module), ('controller_card', controller_card), ])


