# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os
from common.DeviceTypes import DeviceTypeEnum
from ..driver_api.FilterFields import FilterFieldEnum, ORM_DeviceDriverEnum

TRUE_VALUES = {'T', 'TRUE', 'YES', '1'}
DEVICE_EMULATED_ONLY = os.environ.get('DEVICE_EMULATED_ONLY')
LOAD_ALL_DEVICE_DRIVERS = (DEVICE_EMULATED_ONLY is None) or (DEVICE_EMULATED_ONLY.upper() not in TRUE_VALUES)

DRIVERS = []

from .emulated.EmulatedDriver import EmulatedDriver # pylint: disable=wrong-import-position
DRIVERS.append(
    (EmulatedDriver, [
        {
            # Driver==unspecified & no device type specified => use Emulated
            FilterFieldEnum.DRIVER: ORM_DeviceDriverEnum.UNDEFINED,
        },
        {
            # Emulated OLS/Packet Router, specifying Undefined/OpenConfig/TAPI Driver => use EmulatedDriver
            FilterFieldEnum.DEVICE_TYPE: [
                DeviceTypeEnum.EMULATED_OPEN_LINE_SYSTEM,
                DeviceTypeEnum.EMULATED_PACKET_ROUTER,
            ],
            FilterFieldEnum.DRIVER     : [
                ORM_DeviceDriverEnum.UNDEFINED,
                ORM_DeviceDriverEnum.OPENCONFIG,
                ORM_DeviceDriverEnum.TRANSPORT_API
            ],
        }
    ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .openconfig.OpenConfigDriver import OpenConfigDriver # pylint: disable=wrong-import-position
    DRIVERS.append(
        (OpenConfigDriver, [
            {
                # Real Packet Router, specifying OpenConfig Driver => use OpenConfigDriver
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.PACKET_ROUTER,
                FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.OPENCONFIG,
            }
        ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .transport_api.TransportApiDriver import TransportApiDriver # pylint: disable=wrong-import-position
    DRIVERS.append(
        (TransportApiDriver, [
            {
                # Real OLS, specifying TAPI Driver => use TransportApiDriver
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.OPTICAL_LINE_SYSTEM,
                FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.TRANSPORT_API,
            }
        ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .p4.p4_driver import P4Driver # pylint: disable=wrong-import-position
    DRIVERS.append(
        (P4Driver, [
            {
                # Real P4 Switch, specifying P4 Driver => use P4Driver
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.P4_SWITCH,
                FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.P4,
            }
        ]))

if LOAD_ALL_DEVICE_DRIVERS:
    from .microwave.IETFApiDriver import IETFApiDriver # pylint: disable=wrong-import-position
    DRIVERS.append(
        (IETFApiDriver, [
            {
                FilterFieldEnum.DEVICE_TYPE: DeviceTypeEnum.MICROVAWE_RADIO_SYSTEM,
                FilterFieldEnum.DRIVER     : ORM_DeviceDriverEnum.IETF_NETWORK_TOPOLOGY,
            }
        ]))
