# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from common.Constants import ServiceNameEnum
from common.Settings import get_service_port_grpc
from common.orm.backend.BackendEnum import BackendEnum
from common.orm.Database import Database
from common.orm.Factory import get_database_backend
from common.proto.device_pb2_grpc import add_DeviceServiceServicer_to_server
from common.tools.service.GenericGrpcService import GenericGrpcService
from .driver_api.DriverInstanceCache import DriverInstanceCache
from .DeviceServiceServicerImpl import DeviceServiceServicerImpl
from .MonitoringLoops import MonitoringLoops

class DeviceService(GenericGrpcService):
    def __init__(self, driver_instance_cache : DriverInstanceCache, cls_name: str = __name__) -> None:
        port = get_service_port_grpc(ServiceNameEnum.DEVICE)
        super().__init__(port, cls_name=cls_name)
        database = Database(get_database_backend(backend=BackendEnum.INMEMORY))
        self.monitoring_loops = MonitoringLoops(database)
        self.device_servicer = DeviceServiceServicerImpl(database, driver_instance_cache, self.monitoring_loops)

    def install_servicers(self):
        self.monitoring_loops.start()
        add_DeviceServiceServicer_to_server(self.device_servicer, self.server)

    def stop(self):
        super().stop()
        self.monitoring_loops.stop()
