# 3.3 Debugging individual components in VSCode

## 3.3.1 Source TeraFlow environment variables into .bashrc

With any text editor, open the file `~/.bashrc` and add the following line at the end:
```bash
source ~/tfs-ctrl/tfs_runtime_env_vars.sh
```

"tfs-ctrl" can be substituted by the appropriate path where the controller is deployed.

## 3.3.2 Install VSCode Python extensions
The following extensions are required to execute and debug TeraFlow components in VSCode:

- *Python*. New versions of the extension are known to have some unsolved bugs, it is recommended to downgrade to version **v2022.10.0**. Go to the extension window, select Python, click the arrow next to the "Uninstall" button and select "Install Another Version..."
- *Pylance*

## 3.3.3 Configure VSCode workspace and launch settings
Run VSCode and open the folder with the source code of TeraFlow, this will be the main workspace. Create (if it does not exist) the subfolder `.vscode`. Inside, create and edit the following files:

- `settings.json` 
    ```bash
    {
    "python.analysis.extraPaths": ["<HOME>/.pyenv/versions/3.9.7/envs/teraflow/lib/python3.9/site-packages"],
    }
    ```
    `<HOME>` should be replaced by the path of your home folder. If in the future another version of Python is used, or the virtual environment changes, this file should be updated to reflect the new path of the installed pip packages.

- `launch.json`
    ```bash
    {
        // Use IntelliSense to learn about possible attributes.
        // Hover to view descriptions of existing attributes.
        // For more information, visit: https://go.microsoft.com/fwlink/?linkid=830387
        "version": "0.2.0",
        "configurations": [
            {
                "name": "TFS compute.service",
                "module": "compute.service",
                "python": "${command:python.interpreterPath}",
                "type": "python",
                "request": "launch",
                "justMyCode": true,
                "console": "internalConsole",
                "env": {
                    "PYTHONPATH": "${config:python.analysis.extraPaths}:${workspaceRoot}/src",
                    "LOG_LEVEL": "DEBUG",
                    }
            }
        ]
    }
    ```
    This file contains the configuration necessary to execute the `"compute"` component from the TeraFlow controller, while providing debugging capabilities (e.g., breaking points, console log output etc.). After saving, the debugging can be started from the "Run and Debug" menu.

    Additional profiles can be added to the JSON file under the `"configurations"` arrray. Copy & paste the existing one and change the `"name"` and  `"module"` fields.