# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import path_srlgs_name
class path_srlgs_names(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/path-constraints/path-srlgs-names. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for the list of named SRLGs.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path_srlgs_name',)

  _yang_name = 'path-srlgs-names'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path_srlgs_name = YANGDynClass(base=YANGListType("usage",path_srlgs_name.path_srlgs_name, yang_name="path-srlgs-name", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-srlgs-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'path-constraints', 'path-srlgs-names']

  def _get_path_srlgs_name(self):
    """
    Getter method for path_srlgs_name, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_constraints/path_srlgs_names/path_srlgs_name (list)

    YANG Description: List of named SRLGs to be included or excluded.
    """
    return self.__path_srlgs_name
      
  def _set_path_srlgs_name(self, v, load=False):
    """
    Setter method for path_srlgs_name, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_constraints/path_srlgs_names/path_srlgs_name (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_srlgs_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_srlgs_name() directly.

    YANG Description: List of named SRLGs to be included or excluded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("usage",path_srlgs_name.path_srlgs_name, yang_name="path-srlgs-name", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-srlgs-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_srlgs_name must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("usage",path_srlgs_name.path_srlgs_name, yang_name="path-srlgs-name", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-srlgs-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)""",
        })

    self.__path_srlgs_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_srlgs_name(self):
    self.__path_srlgs_name = YANGDynClass(base=YANGListType("usage",path_srlgs_name.path_srlgs_name, yang_name="path-srlgs-name", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='usage', extensions=None), is_container='list', yang_name="path-srlgs-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=False)

  path_srlgs_name = __builtin__.property(_get_path_srlgs_name)


  _pyangbind_elements = OrderedDict([('path_srlgs_name', path_srlgs_name), ])


