# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from typing import List, Optional

class Parameters:
    def __init__(
        self, num_requests : int, request_types : List[str], offered_load : Optional[float] = None,
        inter_arrival_time : Optional[float] = None, holding_time : Optional[float] = None,
        dry_mode : bool = False
    ) -> None:
        self._num_requests = num_requests
        self._request_types = request_types
        self._offered_load = offered_load
        self._inter_arrival_time = inter_arrival_time
        self._holding_time = holding_time
        self._dry_mode = dry_mode

        if self._offered_load is None and self._holding_time is not None and self._inter_arrival_time is not None:
            self._offered_load = self._holding_time / self._inter_arrival_time
        elif self._offered_load is not None and self._holding_time is not None and self._inter_arrival_time is None:
            self._inter_arrival_time = self._holding_time / self._offered_load
        elif self._offered_load is not None and self._holding_time is None and self._inter_arrival_time is not None:
            self._holding_time = self._offered_load * self._inter_arrival_time

    @property
    def num_requests(self): return self._num_requests

    @property
    def request_types(self): return self._request_types

    @property
    def offered_load(self): return self._offered_load

    @property
    def inter_arrival_time(self): return self._inter_arrival_time

    @property
    def holding_time(self): return self._holding_time

    @property
    def dry_mode(self): return self._dry_mode
