# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, sys
from .Constants import (
    REQUEST_TYPE_SERVICE_L2NM, REQUEST_TYPE_SERVICE_L3NM, REQUEST_TYPE_SERVICE_TAPI,
    REQUEST_TYPE_SLICE_L2NM, REQUEST_TYPE_SLICE_L3NM)
from .Parameters import Parameters
from .RequestGenerator import RequestGenerator
from .RequestScheduler import RequestScheduler

logging.basicConfig(level=logging.INFO)
LOGGER = logging.getLogger(__name__)

def main():
    LOGGER.info('Starting...')
    parameters = Parameters(
        num_requests = 100,
        request_types = [
            REQUEST_TYPE_SERVICE_L2NM,
            REQUEST_TYPE_SERVICE_L3NM,
            REQUEST_TYPE_SERVICE_TAPI,
            REQUEST_TYPE_SLICE_L2NM,
            REQUEST_TYPE_SLICE_L3NM,
        ],
        offered_load  = 50,
        holding_time  = 10,
        dry_mode      = False, # in dry mode, no request is sent to TeraFlowSDN
    )

    LOGGER.info('Initializing Generator...')
    generator = RequestGenerator(parameters)
    generator.initialize()

    LOGGER.info('Running Schedule...')
    scheduler = RequestScheduler(parameters, generator)
    scheduler.start()

    LOGGER.info('Done!')
    return 0

if __name__ == '__main__':
    sys.exit(main())
