import logging, os, signal, sys, threading
from prometheus_client import start_http_server
from common.database.Factory import get_database
from device.service.DeviceService import DeviceService
from device.Config import SERVICE_PORT, MAX_WORKERS, GRACE_PERIOD, LOG_LEVEL, METRICS_PORT

terminate = threading.Event()
logger = None

def signal_handler(signal, frame):
    global terminate, logger
    logger.warning('Terminate signal received')
    terminate.set()

def main():
    global terminate, logger

    service_port = os.environ.get('DEVICESERVICE_SERVICE_PORT_GRPC', SERVICE_PORT)
    max_workers  = os.environ.get('MAX_WORKERS',  MAX_WORKERS )
    grace_period = os.environ.get('GRACE_PERIOD', GRACE_PERIOD)
    log_level    = os.environ.get('LOG_LEVEL',    LOG_LEVEL   )
    metrics_port = os.environ.get('METRICS_PORT', METRICS_PORT)

    logging.basicConfig(level=log_level)
    logger = logging.getLogger(__name__)

    signal.signal(signal.SIGINT,  signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    logger.info('Starting...')

    # Start metrics server
    start_http_server(metrics_port)

    # Get database instance
    database = get_database()

    # Starting device service
    service = DeviceService(database, port=service_port, max_workers=max_workers, grace_period=grace_period)
    service.start()

    # Wait for Ctrl+C or termination signal
    while not terminate.wait(0.1): pass

    logger.info('Terminating...')
    service.stop()

    logger.info('Bye')
    return(0)

if __name__ == '__main__':
    sys.exit(main())
