# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from sqlalchemy import Column, ForeignKey #, ForeignKeyConstraint
#from sqlalchemy.dialects.postgresql import UUID
from sqlalchemy.orm import relationship
from ._Base import _Base

# class ConnectionSubServiceModel(Model):
#     pk = PrimaryKeyField()
#     connection_fk = ForeignKeyField(ConnectionModel)
#     sub_service_fk = ForeignKeyField(ServiceModel)

class LinkEndPointModel(_Base):
    __tablename__ = 'link_endpoint'

    link_uuid     = Column(ForeignKey('link.link_uuid',         ondelete='CASCADE' ), primary_key=True)
    endpoint_uuid = Column(ForeignKey('endpoint.endpoint_uuid', ondelete='RESTRICT'), primary_key=True)

    link     = relationship('LinkModel',     back_populates='link_endpoints', lazy='joined')
    endpoint = relationship('EndPointModel', lazy='joined') # back_populates='link_endpoints'

#class ServiceEndPointModel(_Base):
#    __tablename__ = 'service_endpoint'
#
#    context_uuid  = Column(UUID(as_uuid=False), primary_key=True)
#    service_uuid  = Column(UUID(as_uuid=False), primary_key=True)
#    topology_uuid = Column(UUID(as_uuid=False), primary_key=True)
#    device_uuid   = Column(UUID(as_uuid=False), primary_key=True)
#    endpoint_uuid = Column(UUID(as_uuid=False), primary_key=True)
#
#    service  = relationship('ServiceModel',  back_populates='service_endpoints', lazy='joined')
#    endpoint = relationship('EndPointModel', back_populates='service_endpoints', lazy='joined')
#    writer = relationship(
#        "Writer",
#        primaryjoin="and_(Writer.id == foreign(Article.writer_id), "
#        "Writer.magazine_id == Article.magazine_id)",
#    )
#
#    __table_args__ = (
#        ForeignKeyConstraint(
#            ['context_uuid', 'service_uuid'],
#            ['service.context_uuid', 'service.service_uuid'],
#            ondelete='CASCADE'),
#        ForeignKeyConstraint(
#            ['context_uuid', 'topology_uuid', 'device_uuid', 'endpoint_uuid'],
#            ['endpoint.context_uuid', 'endpoint.topology_uuid', 'endpoint.device_uuid', 'endpoint.endpoint_uuid'],
#            ondelete='CASCADE'),
#    )

# class SliceEndPointModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     endpoint_fk = ForeignKeyField(EndPointModel)

# class SliceServiceModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     service_fk = ForeignKeyField(ServiceModel)

# class SliceSubSliceModel(Model):
#     pk = PrimaryKeyField()
#     slice_fk = ForeignKeyField(SliceModel)
#     sub_slice_fk = ForeignKeyField(SliceModel)

class TopologyDeviceModel(_Base):
    __tablename__ = 'topology_device'

    topology_uuid = Column(ForeignKey('topology.topology_uuid', ondelete='RESTRICT'), primary_key=True)
    device_uuid   = Column(ForeignKey('device.device_uuid',     ondelete='CASCADE' ), primary_key=True)

    #topology = relationship('TopologyModel', lazy='joined') # back_populates='topology_devices'
    device   = relationship('DeviceModel',   lazy='joined') # back_populates='topology_devices'

class TopologyLinkModel(_Base):
    __tablename__ = 'topology_link'

    topology_uuid = Column(ForeignKey('topology.topology_uuid', ondelete='RESTRICT'), primary_key=True)
    link_uuid     = Column(ForeignKey('link.link_uuid',         ondelete='CASCADE' ), primary_key=True)

    #topology = relationship('TopologyModel', lazy='joined') # back_populates='topology_links'
    link     = relationship('LinkModel',     lazy='joined') # back_populates='topology_links'
