# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, operator
from typing import Dict, List
from sqlalchemy import Column, ForeignKey
from sqlalchemy.dialects.postgresql import UUID
from context.service.database.Base import Base
from sqlalchemy.orm import relationship

LOGGER = logging.getLogger(__name__)

class LinkModel(Base):
    __tablename__ = 'Link'
    link_uuid = Column(UUID(as_uuid=False), primary_key=True, unique=True)

    @staticmethod
    def main_pk_name():
        return 'link_uuid'

    def dump_id(self) -> Dict:
        return {'link_uuid': {'uuid': self.link_uuid}}

    def dump_endpoint_ids(self) -> List[Dict]:
        return [endpoint.dump_id() for endpoint in self.endpoints]

    def dump(self, endpoints=None) -> Dict:
        result = {
                'link_id': self.dump_id()
            }
        if endpoints:
            result['link_endpoint_ids'] = []
            for endpoint in endpoints:
                dump = endpoint.dump_id()
                LOGGER.info(dump)
                result['link_endpoint_ids'].append(dump)

            LOGGER.info(result['link_endpoint_ids'])

        LOGGER.info(result)
        return result
