/*
* Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package eu.teraflow.ztp;

import io.smallrye.config.SmallRyeConfig;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.config.Config;

public class MockZtpConfiguration {
    @Inject Config config;

    @Produces
    @ApplicationScoped
    @io.quarkus.test.Mock
    ZtpConfiguration ztpConfiguration() {
        return config.unwrap(SmallRyeConfig.class).getConfigMapping(ZtpConfiguration.class);
    }
}
