from common.database.api.context.Constants import DEFAULT_CONTEXT_ID, DEFAULT_TOPOLOGY_ID
from common.database.api.context.service.ServiceState import ServiceState
from common.database.api.context.service.ServiceType import ServiceType
from common.database.api.context.topology.device.OperationalStatus import OperationalStatus

CONTEXT_ID = {'contextUuid': {'uuid': DEFAULT_CONTEXT_ID}}

TOPOLOGY_ID = {'contextId': CONTEXT_ID, 'topoId': {'uuid': DEFAULT_TOPOLOGY_ID}}

DEVICE_ID_DEV1 = {'device_id': {'uuid': 'dev1'}}
DEVICE_DEV1 = {
    'device_id': DEVICE_ID_DEV1, 'device_type': 'ROADM', 'device_config': {'device_config': '<config/>'},
    'devOperationalStatus': OperationalStatus.ENABLED.value,
    'endpointList' : [
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port2'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port3'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port101'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port102'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port103'}}, 'port_type': 'OCH'},
    ]
}

DEVICE_ID_DEV2 = {'device_id': {'uuid': 'dev2'}}
DEVICE_DEV2 = {
    'device_id': DEVICE_ID_DEV2, 'device_type': 'ROADM', 'device_config': {'device_config': '<config/>'},
    'devOperationalStatus': OperationalStatus.ENABLED.value,
    'endpointList' : [
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port1'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port3'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port101'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port102'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port103'}}, 'port_type': 'OCH'},
    ]
}

DEVICE_ID_DEV3 = {'device_id': {'uuid': 'dev3'}}
DEVICE_DEV3 = {
    'device_id': DEVICE_ID_DEV3,
    'device_type': 'ROADM',
    'device_config': {'device_config': '<config/>'},
    'devOperationalStatus': OperationalStatus.ENABLED.value,
    'endpointList' : [
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port1'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port2'}}, 'port_type': 'WDM'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port101'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port102'}}, 'port_type': 'OCH'},
        {'port_id': {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port103'}}, 'port_type': 'OCH'},
    ]
}

LINK_ID_DEV1_DEV2 = {'link_id': {'uuid': 'dev1/port2 ==> dev2/port1'}}
LINK_DEV1_DEV2 = {
    'link_id': LINK_ID_DEV1_DEV2,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port2'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port1'}},
    ]
}

LINK_ID_DEV1_DEV3 = {'link_id': {'uuid': 'dev1/port3 ==> dev3/port1'}}
LINK_DEV1_DEV3 = {
    'link_id': LINK_ID_DEV1_DEV3,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port3'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port1'}},
    ]
}

LINK_ID_DEV2_DEV1 = {'link_id': {'uuid': 'dev2/port1 ==> dev1/port2'}}
LINK_DEV2_DEV1 = {
    'link_id': LINK_ID_DEV2_DEV1,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port1'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port2'}},
    ]
}

LINK_ID_DEV2_DEV3 = {'link_id': {'uuid': 'dev2/port3 ==> dev3/port2'}}
LINK_DEV2_DEV3 = {
    'link_id': LINK_ID_DEV2_DEV3,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port3'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port2'}},
    ]
}

LINK_ID_DEV3_DEV1 = {'link_id': {'uuid': 'dev3/port1 ==> dev1/port3'}}
LINK_DEV3_DEV1 = {
    'link_id': LINK_ID_DEV3_DEV1,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port1'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port3'}},
    ]
}

LINK_ID_DEV3_DEV2 = {'link_id': {'uuid': 'dev3/port2 ==> dev2/port3'}}
LINK_DEV3_DEV2 = {
    'link_id': LINK_ID_DEV3_DEV2,
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port2'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port3'}},
    ]
}

SERVICE_ID_SVC1 = {'contextId': CONTEXT_ID, 'cs_id': {'uuid': 'svc1'}}
SERVICE_SVC1 = {
    'cs_id': SERVICE_ID_SVC1, 'serviceType': ServiceType.L3NM.value, 'serviceConfig': {'serviceConfig': '<config/>'},
    'serviceState': {'serviceState': ServiceState.PLANNED.value},
    'constraint': [
        {'constraint_type': 'latency_ms', 'constraint_value': '100'},
        {'constraint_type': 'hops', 'constraint_value': '5'},
    ],
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port101'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port101'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port101'}},
    ]
}

SERVICE_ID_SVC2 = {'contextId': CONTEXT_ID, 'cs_id': {'uuid': 'svc2'}}
SERVICE_SVC2 = {
    'cs_id': SERVICE_ID_SVC2, 'serviceType': ServiceType.L3NM.value, 'serviceConfig': {'serviceConfig': '<config/>'},
    'serviceState': {'serviceState': ServiceState.PLANNED.value},
    'constraint': [
        {'constraint_type': 'latency_ms', 'constraint_value': '100'},
        {'constraint_type': 'hops', 'constraint_value': '5'},
    ],
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port102'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port102'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port102'}},
    ]
}

SERVICE_ID_SVC3 = {'contextId': CONTEXT_ID, 'cs_id': {'uuid': 'svc3'}}
SERVICE_SVC3 = {
    'cs_id': SERVICE_ID_SVC3, 'serviceType': ServiceType.L3NM.value, 'serviceConfig': {'serviceConfig': '<config/>'},
    'serviceState': {'serviceState': ServiceState.PLANNED.value},
    'constraint': [
        {'constraint_type': 'latency_ms', 'constraint_value': '100'},
        {'constraint_type': 'hops', 'constraint_value': '5'},
    ],
    'endpointList' : [
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV1, 'port_id': {'uuid' : 'port103'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV2, 'port_id': {'uuid' : 'port103'}},
        {'topoId': TOPOLOGY_ID, 'dev_id': DEVICE_ID_DEV3, 'port_id': {'uuid' : 'port103'}},
    ]
}
