def validate_empty(message):
    assert type(message) is dict
    assert len(message.keys()) == 0

def validate_uuid(message, allow_empty=False):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'uuid' in message
    assert type(message['uuid']) is str
    if allow_empty: return
    assert len(message['uuid']) > 1

def validate_context_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'contextUuid' in message
    validate_uuid(message['contextUuid'])

def validate_device_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'device_id' in message
    validate_uuid(message['device_id'])

def validate_link_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'link_id' in message
    validate_uuid(message['link_id'])

def validate_topology_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 2
    assert 'contextId' in message
    validate_context_id(message['contextId'])
    assert 'topoId' in message
    validate_uuid(message['topoId'])

def validate_device_config(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'device_config' in message
    assert type(message['device_config']) is str

def validate_device_operational_status(message):
    assert type(message) is str
    assert message in ['KEEP_STATE', 'ENABLED', 'DISABLED']

def validate_endpoint_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 3
    assert 'topoId' in message
    validate_topology_id(message['topoId'])
    assert 'dev_id' in message
    validate_device_id(message['dev_id'])
    assert 'port_id' in message
    validate_uuid(message['port_id'])

def validate_endpoint(message):
    assert type(message) is dict
    assert len(message.keys()) == 2
    assert 'port_id' in message
    validate_endpoint_id(message['port_id'])
    assert 'port_type' in message
    assert type(message['port_type']) is str

def validate_device(message):
    assert type(message) is dict
    assert len(message.keys()) == 5
    assert 'device_id' in message
    validate_device_id(message['device_id'])
    assert 'device_type' in message
    assert type(message['device_type']) is str
    assert 'device_config' in message
    validate_device_config(message['device_config'])
    assert 'devOperationalStatus' in message
    validate_device_operational_status(message['devOperationalStatus'])
    assert 'endpointList' in message
    assert type(message['endpointList']) is list
    for endpoint in message['endpointList']: validate_endpoint(endpoint)

def validate_link(message):
    assert type(message) is dict
    assert len(message.keys()) == 2
    assert 'link_id' in message
    validate_link_id(message['link_id'])
    assert 'endpointList' in message
    assert type(message['endpointList']) is list
    for endpoint_id in message['endpointList']: validate_endpoint_id(endpoint_id)

def validate_topology(message):
    assert type(message) is dict
    assert len(message.keys()) > 0
    assert 'topoId' in message
    validate_topology_id(message['topoId'])
    assert 'device' in message
    assert type(message['device']) is list
    for device in message['device']: validate_device(device)
    assert 'link' in message
    assert type(message['link']) is list
    for link in message['link']: validate_link(link)

def validate_topology_is_empty(message):
    validate_topology(message)
    assert len(message['device']) == 0
    assert len(message['link']) == 0

def validate_topology_has_devices(message):
    validate_topology(message)
    assert len(message['device']) > 0

def validate_topology_has_links(message):
    validate_topology(message)
    assert len(message['link']) > 0

def validate_service_id(message):
    assert type(message) is dict
    assert len(message.keys()) == 2
    assert 'contextId' in message
    validate_context_id(message['contextId'])
    assert 'cs_id' in message
    validate_uuid(message['cs_id'])

def validate_service(message):
    assert type(message) is dict
    assert len(message.keys()) > 1
    assert 'cs_id' in message

def validate_service_list(message):
    assert type(message) is dict
    assert len(message.keys()) == 1
    assert 'cs' in message
    assert type(message['cs']) is list
    for cs in message['cs']: validate_service(cs)

def validate_service_list_is_empty(message):
    validate_service_list(message)
    assert len(message['cs']) == 0

def validate_service_list_is_not_empty(message):
    validate_service_list(message)
    assert len(message['cs']) > 0
