def format_key(key_pattern, instance, **kwargs):
    attributes = {}
    for attribute_name in instance.__dir__():
        if attribute_name[0] == '_': continue
        attribute_obj = getattr(instance, attribute_name, None)
        if attribute_obj is None: continue
        if type(attribute_obj).__name__ == 'method': continue
        attributes[attribute_name] = attribute_obj
    attributes.update(kwargs)
    return key_pattern.format(**attributes)
