from __future__ import annotations
from typing import TYPE_CHECKING, Dict
from common.database.api.context.Keys import KEY_SERVICE_CONSTRAINT
from common.database.api.entity._Entity import _Entity

if TYPE_CHECKING:
    from common.database.api.context.Context import Context
    from common.database.api.context.service.Service import Service

VALIDATORS = {
    'constraint_value': lambda v: v is not None and isinstance(v, str) and (len(v) > 0),
}

TRANSCODERS = {} # no transcoding applied to attributes

class Constraint(_Entity):
    def __init__(self, constraint_type : str, parent : 'Service'):
        super().__init__(parent, constraint_type, KEY_SERVICE_CONSTRAINT, VALIDATORS, TRANSCODERS)

    @property
    def parent(self) -> 'Service': return self._parent

    @property
    def context(self) -> 'Context': return self.parent.context

    @property
    def context_uuid(self) -> str: return self.parent.context_uuid

    @property
    def service(self) -> 'Service': return self.parent

    @property
    def service_uuid(self) -> str: return self.parent.service_uuid

    @property
    def constraint_type(self) -> str: return self._entity_uuid

    def create(self, constraint_value : str) -> 'Constraint':
        self.update(update_attributes={
            'constraint_value': constraint_value,
        })
        self.parent.constraints.add(self.constraint_type)
        return self

    def update(self, update_attributes={}, remove_attributes=[]) -> 'Constraint':
        self.attributes.update(update_attributes=update_attributes, remove_attributes=remove_attributes)
        return self

    def delete(self) -> None:
        self.attributes.delete()
        self.parent.constraints.delete(self.constraint_type)

    def dump_id(self) -> Dict:
        return {
            'constraint_type': self.constraint_type,
        }

    def dump(self) -> Dict:
        attributes = self.attributes.get()
        return {
            'constraint_type': self.constraint_type,
            'constraint_value': attributes.get('constraint_value', None),
        }
