/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.List;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.SquareLinker;
import net.sourceforge.plantuml.cucadiagram.SquareMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Magma {
    private final CucaDiagram system;
    private final List<ILeaf> standalones;
    private final LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getInvisible();

    public Magma(CucaDiagram cucaDiagram, List<ILeaf> list) {
        this.system = cucaDiagram;
        this.standalones = list;
    }

    public void putInSquare() {
        SquareLinker<ILeaf> squareLinker = new SquareLinker<ILeaf>(){

            @Override
            public void topDown(ILeaf iLeaf, ILeaf iLeaf2) {
                Magma.this.system.addLink(new Link(iLeaf, iLeaf2, Magma.this.linkType, null, 2));
            }

            @Override
            public void leftRight(ILeaf iLeaf, ILeaf iLeaf2) {
                Magma.this.system.addLink(new Link(iLeaf, iLeaf2, Magma.this.linkType, null, 1));
            }
        };
        new SquareMaker<ILeaf>().putInSquare(this.standalones, squareLinker);
    }

    public IGroup getContainer() {
        IGroup iGroup = this.standalones.get(0).getParentContainer();
        if (iGroup == null) {
            return null;
        }
        return iGroup.getParentContainer();
    }

    public boolean isComplete() {
        IGroup iGroup = this.getContainer();
        if (iGroup == null) {
            return false;
        }
        return iGroup.size() == this.standalones.size();
    }

    private int squareSize() {
        return SquareMaker.computeBranch(this.standalones.size());
    }

    private ILeaf getTopLeft() {
        return this.standalones.get(0);
    }

    private ILeaf getBottomLeft() {
        int n = SquareMaker.getBottomLeft(this.standalones.size());
        return this.standalones.get(n);
    }

    private ILeaf getTopRight() {
        int n = this.squareSize();
        return this.standalones.get(n - 1);
    }

    public String toString() {
        return this.standalones.get(0).getParentContainer() + " " + this.standalones.toString() + " " + this.isComplete();
    }

    public void linkToDown(Magma magma) {
        this.system.addLink(new Link(this.getBottomLeft(), magma.getTopLeft(), this.linkType, null, 2));
    }

    public void linkToRight(Magma magma) {
        this.system.addLink(new Link(this.getTopRight(), magma.getTopLeft(), this.linkType, null, 1));
    }
}

