# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import node_template
from . import link_template
class templates(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/te/templates. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for templates used for a TE
topology.
  """
  __slots__ = ('_path_helper', '_extmethods', '__node_template','__link_template',)

  _yang_name = 'templates'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__node_template = YANGDynClass(base=YANGListType("name",node_template.node_template, yang_name="node-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="node-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    self.__link_template = YANGDynClass(base=YANGListType("name",link_template.link_template, yang_name="link-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'te', 'templates']

  def _get_node_template(self):
    """
    Getter method for node_template, mapped from YANG variable /networks/te/templates/node_template (list)

    YANG Description: The list of TE node templates used to define sharable
and reusable TE node attributes.
    """
    return self.__node_template
      
  def _set_node_template(self, v, load=False):
    """
    Setter method for node_template, mapped from YANG variable /networks/te/templates/node_template (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node_template is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node_template() directly.

    YANG Description: The list of TE node templates used to define sharable
and reusable TE node attributes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",node_template.node_template, yang_name="node-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="node-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node_template must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",node_template.node_template, yang_name="node-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="node-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__node_template = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node_template(self):
    self.__node_template = YANGDynClass(base=YANGListType("name",node_template.node_template, yang_name="node-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="node-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)


  def _get_link_template(self):
    """
    Getter method for link_template, mapped from YANG variable /networks/te/templates/link_template (list)

    YANG Description: The list of TE link templates used to define sharable
and reusable TE link attributes.
    """
    return self.__link_template
      
  def _set_link_template(self, v, load=False):
    """
    Setter method for link_template, mapped from YANG variable /networks/te/templates/link_template (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_template is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_template() directly.

    YANG Description: The list of TE link templates used to define sharable
and reusable TE link attributes.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",link_template.link_template, yang_name="link-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_template must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",link_template.link_template, yang_name="link-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__link_template = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_template(self):
    self.__link_template = YANGDynClass(base=YANGListType("name",link_template.link_template, yang_name="link-template", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="link-template", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

  node_template = __builtin__.property(_get_node_template, _set_node_template)
  link_template = __builtin__.property(_get_link_template, _set_link_template)


  _pyangbind_elements = OrderedDict([('node_template', node_template), ('link_template', link_template), ])


