# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class recovery(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/te/recovery. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Status of the recovery process.
  """
  __slots__ = ('_path_helper', '_extmethods', '__restoration_status','__protection_status',)

  _yang_name = 'recovery'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__restoration_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="restoration-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)
    self.__protection_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="protection-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'te', 'recovery']

  def _get_restoration_status(self):
    """
    Getter method for restoration_status, mapped from YANG variable /networks/network/link/te/recovery/restoration_status (te-types:te-recovery-status)

    YANG Description: Restoration status.
    """
    return self.__restoration_status
      
  def _set_restoration_status(self, v, load=False):
    """
    Setter method for restoration_status, mapped from YANG variable /networks/network/link/te/recovery/restoration_status (te-types:te-recovery-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_restoration_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_restoration_status() directly.

    YANG Description: Restoration status.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="restoration-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """restoration_status must be of a type compatible with te-types:te-recovery-status""",
          'defined-type': "te-types:te-recovery-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="restoration-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)""",
        })

    self.__restoration_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_restoration_status(self):
    self.__restoration_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="restoration-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)


  def _get_protection_status(self):
    """
    Getter method for protection_status, mapped from YANG variable /networks/network/link/te/recovery/protection_status (te-types:te-recovery-status)

    YANG Description: Protection status.
    """
    return self.__protection_status
      
  def _set_protection_status(self, v, load=False):
    """
    Setter method for protection_status, mapped from YANG variable /networks/network/link/te/recovery/protection_status (te-types:te-recovery-status)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protection_status is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protection_status() directly.

    YANG Description: Protection status.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="protection-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protection_status must be of a type compatible with te-types:te-recovery-status""",
          'defined-type': "te-types:te-recovery-status",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="protection-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)""",
        })

    self.__protection_status = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protection_status(self):
    self.__protection_status = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'normal': {}, 'recovery-started': {}, 'recovery-succeeded': {}, 'recovery-failed': {}, 'reversion-started': {}, 'reversion-succeeded': {}, 'reversion-failed': {}, 'recovery-unavailable': {}, 'recovery-admin': {}, 'wait-to-restore': {}},), is_leaf=True, yang_name="protection-status", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-types:te-recovery-status', is_config=False)

  restoration_status = __builtin__.property(_get_restoration_status)
  protection_status = __builtin__.property(_get_protection_status)


  _pyangbind_elements = OrderedDict([('restoration_status', restoration_status), ('protection_status', protection_status), ])


