# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# for development purposes only

export CONTEXTSERVICE_SERVICE_HOST=`kubectl get service/contextservice -n tf-dev -o jsonpath='{.spec.clusterIP}'`

echo Context IP: $CONTEXTSERVICE_SERVICE_HOST

export DEVICESERVICE_SERVICE_HOST=`kubectl get service/deviceservice -n tf-dev -o jsonpath='{.spec.clusterIP}'`

echo Device IP: $DEVICESERVICE_SERVICE_HOST

export PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION='python'
export HOST="127.0.0.1"
export FLASK_ENV="development"

# python3 -m webbrowser http://${HOST}:8004

python -m webui.service
