#pylint: disable=invalid-name, missing-function-docstring, line-too-long, logging-fstring-interpolation, missing-class-docstring, missing-module-docstring
import inspect
import os
import json
import pytest
from ..constellation import Constellation, ConstellationDeserializationError

resources = os.path.join(os.path.dirname(os.path.abspath(inspect.stack()[0][1])), "resources")

def test_constellation_json():
    # With a name
    with open(os.path.join(resources, "constellations-expanded.json"), "r", encoding="UTF-8") as f:
        j = json.load(f)

        # A pre-planned constellation without endpoints
        constellation = Constellation(j[0])
        assert constellation.constellation_id == "169860ee-c1b8-4ae1-8f6e-81920a6ee09d"
        assert not constellation.is_vti_mode()
        assert not constellation.ifnames()

        # Proper constellation with endpoints
        constellation = Constellation(j[1])
        assert constellation.constellation_id == "84d9b09c-017d-4ac5-b8cd-d1102db1e070"
        assert not constellation.is_vti_mode()
        print(constellation.ifnames())
        assert ['XR HUB 2|XR-T4', 'XR HUB 2|XR-T1', 'XR HUB 2|XR-T2', 'XR HUB 2|XR-T3', 'XR LEAF 3|XR-T1'] == constellation.ifnames()

        # Remove mandatory key, will raise an exception
        del j[0]["hubModule"]["state"]
        with pytest.raises(ConstellationDeserializationError, match=r"Missing mandatory key 'state'"):
            _constellation = Constellation(j[0])
