import json
from typing import Any, Dict, Union
from context.proto.context_pb2 import ConfigActionEnum

def json_config_rule(action : ConfigActionEnum, resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    if not isinstance(resource_value, str): resource_value = json.dumps(resource_value, sort_keys=True)
    return {'action': action, 'resource_key': resource_key, 'resource_value': resource_value}

def json_config_rule_set(resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    return json_config_rule(ConfigActionEnum.CONFIGACTION_SET, resource_key, resource_value)

def json_config_rule_delete(resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    return json_config_rule(ConfigActionEnum.CONFIGACTION_DELETE, resource_key, resource_value)
