package eu.teraflow.automation.device.model;

public class ConfigRule {

    private final ConfigActionEnum configActionEnum;
    private final String resourceKey;
    private final String resourceValue;

    public ConfigRule(ConfigActionEnum configActionEnum, String resourceKey, String resourceValue) {
        this.configActionEnum = configActionEnum;
        this.resourceKey = resourceKey;
        this.resourceValue = resourceValue;
    }

    public ConfigActionEnum getConfigActionEnum() {
        return configActionEnum;
    }

    public String getResourceKey() {
        return resourceKey;
    }

    public String getResourceValue() {
        return resourceValue;
    }

    @Override
    public String toString() {
        return String.format(
                "%s<%s, %s,%s>", getClass().getSimpleName(), configActionEnum, resourceKey, resourceValue);
    }
}
