package eu.teraflow.automation.device;

import eu.teraflow.automation.device.model.Device;
import eu.teraflow.automation.device.model.DeviceConfig;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class DeviceServiceImpl implements DeviceService {

    private final DeviceGateway deviceGateway;

    @Inject
    public DeviceServiceImpl(DeviceGateway deviceGateway) {
        this.deviceGateway = deviceGateway;
    }

    @Override
    public Uni<DeviceConfig> getInitialConfiguration(String deviceId) {

        return deviceGateway.getInitialConfiguration(deviceId);
    }

    @Override
    public Uni<String> configureDevice(Device device) {

        return deviceGateway.configureDevice(device);
    }
}
