package eu.teraflow.automation;

import eu.teraflow.automation.context.ContextService;
import eu.teraflow.automation.device.DeviceService;
import eu.teraflow.automation.device.model.Device;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;

@ApplicationScoped
public class AutomationServiceImpl implements AutomationService {
    private static final Logger LOGGER = Logger.getLogger(AutomationServiceImpl.class);

    private final DeviceService deviceService;
    private final ContextService contextService;

    @Inject
    public AutomationServiceImpl(DeviceService deviceService, ContextService contextService) {
        this.deviceService = deviceService;
        this.contextService = contextService;
    }

    @Override
    public Uni<Device> addDevice(String deviceId) {

        final var deserializedDeviceUni = contextService.getDevice(deviceId);

        deserializedDeviceUni
                // TODO fix subscribe
                .subscribe()
                .with(
                        device -> {
                            final var id = deviceId;

                            if (!device.isEnabled()) {
                                LOGGER.infof("Retrieved %s", device);

                                final var initialConfiguration =
                                        deviceService.getInitialConfiguration(device.getDeviceId());

                                device.enableDevice();
                                LOGGER.infof("Enabled device [%s]", id);

                                initialConfiguration
                                        .subscribe()
                                        .with(
                                                deviceConfig -> {
                                                    device.setDeviceConfiguration(deviceConfig);
                                                    final var configuredDeviceIdUni = deviceService.configureDevice(device);

                                                    configuredDeviceIdUni
                                                            .subscribe()
                                                            .with(
                                                                    configuredDeviceId ->
                                                                            LOGGER.infof(
                                                                                    "Device [%s] has been enabled and configured successfully with %s.\n",
                                                                                    id, deviceConfig));
                                                });
                            } else {
                                LOGGER.infof("%s has been already enabled. Ignoring...", device);
                            }
                        });

        return deserializedDeviceUni;
    }
}
