package eu.teraflow.automation;

import automation.Automation;
import context.ContextOuterClass;
import io.quarkus.grpc.GrpcService;
import io.smallrye.mutiny.Uni;
import javax.inject.Inject;

@GrpcService
public class AutomationGatewayImpl implements AutomationGateway {

    private final AutomationService automationService;
    private final Serializer serializer;

    @Inject
    public AutomationGatewayImpl(AutomationService automationService, Serializer serializer) {
        this.automationService = automationService;
        this.serializer = serializer;
    }

    @Override
    public Uni<Automation.DeviceRole> ztpGetDeviceRole(Automation.DeviceRoleId request) {
        return Uni.createFrom()
                .item(() -> Automation.DeviceRole.newBuilder().setDevRoleId(request).build());
    }

    @Override
    public Uni<Automation.DeviceRoleList> ztpGetDeviceRolesByDeviceId(
            ContextOuterClass.DeviceId request) {
        return Uni.createFrom().item(() -> Automation.DeviceRoleList.newBuilder().build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpAdd(Automation.DeviceRole request) {
        final var deviceId = serializer.deserialize(request.getDevRoleId().getDevId());

        // TODO tie this with return
        automationService.addDevice(deviceId);

        // TODO Set all fields of device role state (create models, serializer)
        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpUpdate(Automation.DeviceRole request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceRoleState> ztpDelete(Automation.DeviceRole request) {
        return Uni.createFrom()
                .item(
                        () ->
                                Automation.DeviceRoleState.newBuilder()
                                        .setDevRoleId(request.getDevRoleId())
                                        .build());
    }

    @Override
    public Uni<Automation.DeviceDeletionResult> ztpDeleteAll(Automation.Empty empty) {
        return Uni.createFrom().item(() -> Automation.DeviceDeletionResult.newBuilder().build());
    }
}
