# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import tiebreaker
class tiebreakers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/local-link-connectivity/optimizations/tiebreakers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for the list of tiebreakers.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tiebreaker',)

  _yang_name = 'tiebreakers'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tiebreaker = YANGDynClass(base=YANGListType("tiebreaker_type",tiebreaker.tiebreaker, yang_name="tiebreaker", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tiebreaker-type', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="tiebreaker", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'local-link-connectivity', 'optimizations', 'tiebreakers']

  def _get_tiebreaker(self):
    """
    Getter method for tiebreaker, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/tiebreakers/tiebreaker (list)

    YANG Description: The list of tiebreaker criteria to apply on an
equally favored set of paths, in order to pick
the best.
    """
    return self.__tiebreaker
      
  def _set_tiebreaker(self, v, load=False):
    """
    Setter method for tiebreaker, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/tiebreakers/tiebreaker (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tiebreaker is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tiebreaker() directly.

    YANG Description: The list of tiebreaker criteria to apply on an
equally favored set of paths, in order to pick
the best.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("tiebreaker_type",tiebreaker.tiebreaker, yang_name="tiebreaker", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tiebreaker-type', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="tiebreaker", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tiebreaker must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("tiebreaker_type",tiebreaker.tiebreaker, yang_name="tiebreaker", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tiebreaker-type', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="tiebreaker", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)""",
        })

    self.__tiebreaker = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tiebreaker(self):
    self.__tiebreaker = YANGDynClass(base=YANGListType("tiebreaker_type",tiebreaker.tiebreaker, yang_name="tiebreaker", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='tiebreaker-type', extensions=None, choice=('algorithm', 'metric')), is_container='list', yang_name="tiebreaker", parent=self, choice=('algorithm', 'metric'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='list', is_config=True)

  tiebreaker = __builtin__.property(_get_tiebreaker, _set_tiebreaker)

  __choices__ = {'algorithm': {'metric': ['tiebreaker']}}
  _pyangbind_elements = OrderedDict([('tiebreaker', tiebreaker), ])


