
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from ._Builder import get_uuid_from_string, get_uuid_random
from common.proto.context_pb2 import DeviceId

def channel_get_uuid(
    channel_name :str , device_id:str, allow_random : bool = False
) -> str:
    

    if len(channel_name) > 0:
        return get_uuid_from_string(channel_name) + device_id
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('channel uuid', channel_name),
       
    ], extra_details=['Channel name is required to produce a channel UUID'])


def transponder_get_uuid(
    opticalconfig_id :str , allow_random : bool = False
) -> str:
    

    if opticalconfig_id is not None:
        return get_uuid_from_string(f"{opticalconfig_id}-transponder")
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('transponder uuid', opticalconfig_id),
       
    ], extra_details=['opticalconfig id is required to produce a transponder UUID'])
    

def roadm_get_uuid(
    opticalconfig_id :str , allow_random : bool = False
) -> str:
    

    if opticalconfig_id is not None:
        return get_uuid_from_string(f"{opticalconfig_id}-roadm")
   

    raise InvalidArgumentsException([
        ('roadm uuid', opticalconfig_id),
       
    ], extra_details=['opticalconfig id is required to produce a roadm UUID'])
    


def opticalconfig_get_uuid ( device_id: DeviceId, allow_random : bool = False) -> str : 
    device_uuid = device_id.device_uuid.uuid
    if (len(device_uuid)>0):
        return get_uuid_from_string(f"{device_uuid}_opticalconfig")
    if allow_random: return get_uuid_random()
    raise InvalidArgumentsException([
        ('DeviceId ', device_id),
       
    ], extra_details=['device_id is required to produce a OpticalConfig UUID'])
    
    
    
def interface_get_uuid(
    interface_name :str , device_id:str, allow_random : bool = False
) -> str:
    

    if len(interface_name) > 0:
        return get_uuid_from_string(interface_name) + device_id
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('interface uuid', interface_name),
       
    ], extra_details=['Interface name is required to produce a interface UUID'])
