# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform - based on the path /components/component/port/breakout-mode/groups/group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for breakout group.
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__num_breakouts','__breakout_speed','__num_physical_channels',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups', 'group', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_num_breakouts(self):
    """
    Getter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    return self.__num_breakouts
      
  def _set_num_breakouts(self, v, load=False):
    """
    Setter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_breakouts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_breakouts() directly.

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_breakouts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_breakouts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_breakouts(self):
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_breakout_speed(self):
    """
    Getter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    return self.__breakout_speed
      
  def _set_breakout_speed(self, v, load=False):
    """
    Setter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_breakout_speed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_breakout_speed() directly.

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """breakout_speed must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform-port:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)""",
        })

    self.__breakout_speed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_breakout_speed(self):
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)


  def _get_num_physical_channels(self):
    """
    Getter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    return self.__num_physical_channels
      
  def _set_num_physical_channels(self, v, load=False):
    """
    Setter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_physical_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_physical_channels() directly.

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_physical_channels must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_physical_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_physical_channels(self):
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  num_breakouts = __builtin__.property(_get_num_breakouts, _set_num_breakouts)
  breakout_speed = __builtin__.property(_get_breakout_speed, _set_breakout_speed)
  num_physical_channels = __builtin__.property(_get_num_physical_channels, _set_num_physical_channels)


  _pyangbind_elements = OrderedDict([('index', index), ('num_breakouts', num_breakouts), ('breakout_speed', breakout_speed), ('num_physical_channels', num_physical_channels), ])


class config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-platform-common - based on the path /components/component/port/breakout-mode/groups/group/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for breakout group.
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__num_breakouts','__breakout_speed','__num_physical_channels',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/platform'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['components', 'component', 'port', 'breakout-mode', 'groups', 'group', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/index (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Each index specifies breakouts that are identical in
terms of speed and the number of physical channels.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_num_breakouts(self):
    """
    Getter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    return self.__num_breakouts
      
  def _set_num_breakouts(self, v, load=False):
    """
    Setter method for num_breakouts, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_breakouts (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_breakouts is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_breakouts() directly.

    YANG Description: Sets the number of interfaces using this breakout group.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_breakouts must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_breakouts = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_breakouts(self):
    self.__num_breakouts = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-breakouts", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)


  def _get_breakout_speed(self):
    """
    Getter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    return self.__breakout_speed
      
  def _set_breakout_speed(self, v, load=False):
    """
    Setter method for breakout_speed, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/breakout_speed (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_breakout_speed is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_breakout_speed() directly.

    YANG Description: Speed of interfaces in this breakout group, supported
values are defined by the ETHERNET_SPEED identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """breakout_speed must be of a type compatible with identityref""",
          'defined-type': "openconfig-platform-port:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)""",
        })

    self.__breakout_speed = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_breakout_speed(self):
    self.__breakout_speed = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_1GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_2500MB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_5GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_10GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_25GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_40GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_50GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_100GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_200GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_400GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_600GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_800GB': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}, 'oc-eth:SPEED_UNKNOWN': {'@module': 'openconfig-if-ethernet', '@namespace': 'http://openconfig.net/yang/interfaces/ethernet'}},), is_leaf=True, yang_name="breakout-speed", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='identityref', is_config=True)


  def _get_num_physical_channels(self):
    """
    Getter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    return self.__num_physical_channels
      
  def _set_num_physical_channels(self, v, load=False):
    """
    Setter method for num_physical_channels, mapped from YANG variable /components/component/port/breakout_mode/groups/group/config/num_physical_channels (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_num_physical_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_num_physical_channels() directly.

    YANG Description: Sets the number of lanes or physical channels assigned
to the interfaces in this breakout group. This leaf need
not be set if there is only one breakout group where all
the interfaces are of equal speed and have equal number
of physical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """num_physical_channels must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)""",
        })

    self.__num_physical_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_num_physical_channels(self):
    self.__num_physical_channels = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="num-physical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/platform/port', defining_module='openconfig-platform-port', yang_type='uint8', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  num_breakouts = __builtin__.property(_get_num_breakouts, _set_num_breakouts)
  breakout_speed = __builtin__.property(_get_breakout_speed, _set_breakout_speed)
  num_physical_channels = __builtin__.property(_get_num_physical_channels, _set_num_physical_channels)


  _pyangbind_elements = OrderedDict([('index', index), ('num_breakouts', num_breakouts), ('breakout_speed', breakout_speed), ('num_physical_channels', num_physical_channels), ])


