from copy import deepcopy
from device.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from .Tools import config_rule_set, config_rule_delete

# use "deepcopy" to prevent propagating forced changes during tests

DEVICE_OC_UUID     = 'DEV2'
DEVICE_OC_TYPE     = 'packet-router'
DEVICE_OC_ADDRESS  = '127.0.0.1'  # populate the Netconf Server IP address of the device to test
DEVICE_OC_PORT     = '830'        # populate the Netconf Server port of the device to test
DEVICE_OC_USERNAME = 'username'   # populate the Netconf Server username of the device to test
DEVICE_OC_PASSWORD = 'password'   # populate the Netconf Server password of the device to test
DEVICE_OC_TIMEOUT  = 120
DEVICE_OC_DRIVERS  = [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG]

DEVICE_OC_ID = {'device_uuid': {'uuid': DEVICE_OC_UUID}}
DEVICE_OC = {
    'device_id': deepcopy(DEVICE_OC_ID),
    'device_type': DEVICE_OC_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_OC_DRIVERS,
    'device_endpoints': [],                     # populated through the driver, leave this list empty
}

DEVICE_OC_CONNECT_RULES = [
    config_rule_set('_connect/address', DEVICE_OC_ADDRESS),
    config_rule_set('_connect/port',    DEVICE_OC_PORT   ),
    config_rule_set('_connect/settings', {
        'username': DEVICE_OC_USERNAME,
        'password': DEVICE_OC_PASSWORD,
        'timeout' : DEVICE_OC_TIMEOUT,
    }),
]

DEVICE_OC_CONFIG_RULES   = []           # populate your configuration rules to test

DEVICE_OC_DECONFIG_RULES = []           # populate your deconfiguration rules to test
