package eu.teraflow.automation.device;

import eu.teraflow.automation.device.model.DeviceConfig;
import eu.teraflow.automation.device.model.DeviceId;
import io.smallrye.mutiny.Uni;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class DeviceServiceImpl implements DeviceService {

    private final DeviceGateway deviceGateway;

    @Inject
    public DeviceServiceImpl(DeviceGateway deviceGateway) {
        this.deviceGateway = deviceGateway;
    }

    @Override
    public Uni<DeviceConfig> getInitialConfiguration(DeviceId deviceId) {

        return deviceGateway.getInitialConfiguration(deviceId);
    }

    @Override
    public Uni<DeviceId> configureDevice(Device device) {

        return deviceGateway.configureDevice(device);
    }
}
