/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.html;

import java.io.PrintWriter;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;

public final class LinkHtmlPrinter {
    private final Link link;
    private final boolean chiral;

    public LinkHtmlPrinter(Link link, IEntity iEntity) {
        this.link = link;
        if (link.getEntity1() == iEntity) {
            this.chiral = false;
        } else if (link.getEntity2() == iEntity) {
            this.chiral = true;
        } else {
            throw new IllegalArgumentException();
        }
    }

    void printLink(PrintWriter printWriter) {
        String string;
        String string2;
        if (this.chiral) {
            string2 = LinkHtmlPrinter.htmlLink(this.link.getEntity1());
            string = "<i>" + StringUtils.unicodeForHtml(this.link.getEntity2().getCode().getFullName()) + "</i>";
        } else {
            string2 = "<i>" + StringUtils.unicodeForHtml(this.link.getEntity1().getCode().getFullName()) + "</i>";
            string = LinkHtmlPrinter.htmlLink(this.link.getEntity2());
        }
        String string3 = this.link.getLabel() == null ? null : StringUtils.unicodeForHtml(this.link.getLabel());
        String string4 = string2;
        String string5 = string;
        if (this.link.getQualifier1() != null) {
            string4 = string4 + " (" + this.link.getQualifier1() + ")";
            if (string3 != null) {
                string3 = "(" + this.link.getQualifier1() + " " + string2 + ") " + string3;
            }
        }
        if (this.link.getQualifier2() != null) {
            string5 = string5 + " (" + this.link.getQualifier2() + ")";
            if (string3 != null) {
                string3 = string3 + " (" + this.link.getQualifier2() + " " + string + ")";
            }
        }
        if (this.chiral) {
            printWriter.println(this.getHtmlChiral(string4, string5));
        } else {
            printWriter.println(this.getHtml(string4, string5));
        }
        if (string3 != null) {
            printWriter.println("&nbsp;:&nbsp;");
            printWriter.println(string3);
        }
    }

    private String getHtml(String string, String string2) {
        LinkDecor linkDecor = this.link.getType().getDecor1();
        LinkDecor linkDecor2 = this.link.getType().getDecor2();
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.NONE) {
            return string + " is linked to " + string2;
        }
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.EXTENDS) {
            return string + " is extended by " + string2;
        }
        if (linkDecor == LinkDecor.EXTENDS && linkDecor2 == LinkDecor.NONE) {
            return string + " extends " + string2;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return string + " is aggregated by  " + string2;
        }
        if (linkDecor == LinkDecor.AGREGATION) {
            return string + " aggregates " + string2;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return string + " is composed by " + string2;
        }
        if (linkDecor == LinkDecor.COMPOSITION) {
            return string + " composes " + string2;
        }
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.ARROW) {
            return string + " is navigable from  " + string2;
        }
        if (linkDecor == LinkDecor.ARROW && linkDecor2 == LinkDecor.NONE) {
            return string + " navigates to  " + string2;
        }
        return string + " " + (Object)((Object)linkDecor) + "-" + (Object)((Object)linkDecor2) + " " + string2;
    }

    private String getHtmlChiral(String string, String string2) {
        LinkDecor linkDecor = this.link.getType().getDecor1();
        LinkDecor linkDecor2 = this.link.getType().getDecor2();
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.NONE) {
            return string2 + " is linked to " + string;
        }
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.EXTENDS) {
            return string2 + " extends " + string;
        }
        if (linkDecor == LinkDecor.EXTENDS && linkDecor2 == LinkDecor.NONE) {
            return string2 + " is extended by " + string;
        }
        if (linkDecor2 == LinkDecor.AGREGATION) {
            return string2 + " aggregates " + string;
        }
        if (linkDecor == LinkDecor.AGREGATION) {
            return string2 + " is aggregated by " + string;
        }
        if (linkDecor2 == LinkDecor.COMPOSITION) {
            return string2 + " composes " + string;
        }
        if (linkDecor == LinkDecor.COMPOSITION) {
            return string2 + " is composed by " + string;
        }
        if (linkDecor == LinkDecor.NONE && linkDecor2 == LinkDecor.ARROW) {
            return string2 + " navigates to  " + string;
        }
        if (linkDecor == LinkDecor.ARROW && linkDecor2 == LinkDecor.NONE) {
            return string2 + " is navigable from  " + string;
        }
        return string + " " + (Object)((Object)linkDecor) + "-" + (Object)((Object)linkDecor2) + " " + string2;
    }

    static String htmlLink(IEntity iEntity) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<a href=\"");
        stringBuilder.append(LinkHtmlPrinter.urlOf(iEntity));
        stringBuilder.append("\">");
        stringBuilder.append(StringUtils.unicodeForHtml(iEntity.getCode().getFullName()));
        stringBuilder.append("</a>");
        return stringBuilder.toString();
    }

    static String urlOf(IEntity iEntity) {
        if (iEntity.getEntityType() == LeafType.NOTE) {
            throw new IllegalArgumentException();
        }
        if (iEntity.getCode().getFullName().matches("[-\\w_ .]+")) {
            return StringUtils.unicodeForHtml(iEntity.getCode().getFullName()) + ".html";
        }
        return StringUtils.unicodeForHtml(iEntity.getUid()) + ".html";
    }
}

