#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

sudo docker stop na1 -t 1
sudo docker stop na2 -t 1
sudo docker stop na3 -t 1
sudo docker stop na4 -t 1

sudo docker rm na2
sudo docker rm na1
sudo docker rm na3
sudo docker rm na4

echo "Creating NewAgent"
echo " It may take a while , Hang on ..."
source "./startExtraNetConfigAgent.sh"  "na1" "2023"
sleep 3

source "./startExtraNetConfigAgent.sh"  "na2" "2024"
sleep 3

screen -dmS t3 -T xterm sh -c 'docker run -p 10.0.2.15:2025:2022 -v ~/tfs-ctrl/tempOC/files:/files --name na3 -it asgamb1/flexscale-node.img:latest ./startNetconfAgent.sh'
screen -dmS t4 -T xterm sh -c 'docker run -p 10.0.2.15:2026:2022 -v ~/tfs-ctrl/tempOC/files:/files --name na4 -it asgamb1/flexscale-node.img:latest ./startNetconfAgent.sh'
