# Copyright 2022-2024 ETSI OSG/SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import enum, functools
from common.proto.qkd_app_pb2 import QKDAppStatusEnum
from ._GrpcToEnum import grpc_to_enum

class ORM_QKDAppStatusEnum(enum.Enum):
    ON           = QKDAppStatusEnum.QKDAPPSTATUS_ON
    DISCONNECTED = QKDAppStatusEnum.QKDAPPSTATUS_DISCONNECTED
    OUT_OF_TIME  = QKDAppStatusEnum.QKDAPPSTATUS_OUT_OF_TIME
    ZOMBIE       = QKDAppStatusEnum.QKDAPPSTATUS_ZOMBIE


grpc_to_enum__qkd_app_status = functools.partial(
    grpc_to_enum, QKDAppStatusEnum, ORM_QKDAppStatusEnum)
