# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import numbered_node_hop
from . import numbered_link_hop
from . import unnumbered_link_hop
from . import as_number_hop
from . import label_hop
class path_element(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/te/templates/link-template/te-link-attributes/underlay/primary-path/path-element. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of path elements describing the service path.
  """
  __slots__ = ('_path_helper', '_extmethods', '__path_element_id','__numbered_node_hop','__numbered_link_hop','__unnumbered_link_hop','__as_number_hop','__label_hop',)

  _yang_name = 'path-element'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__path_element_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="path-element-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    self.__numbered_node_hop = YANGDynClass(base=numbered_node_hop.numbered_node_hop, is_container='container', yang_name="numbered-node-hop", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__numbered_link_hop = YANGDynClass(base=numbered_link_hop.numbered_link_hop, is_container='container', yang_name="numbered-link-hop", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__unnumbered_link_hop = YANGDynClass(base=unnumbered_link_hop.unnumbered_link_hop, is_container='container', yang_name="unnumbered-link-hop", parent=self, choice=('type', 'unnumbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__as_number_hop = YANGDynClass(base=as_number_hop.as_number_hop, is_container='container', yang_name="as-number-hop", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    self.__label_hop = YANGDynClass(base=label_hop.label_hop, is_container='container', yang_name="label-hop", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'te', 'templates', 'link-template', 'te-link-attributes', 'underlay', 'primary-path', 'path-element']

  def _get_path_element_id(self):
    """
    Getter method for path_element_id, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/path_element_id (uint32)

    YANG Description: To identify the element in a path.
    """
    return self.__path_element_id
      
  def _set_path_element_id(self, v, load=False):
    """
    Setter method for path_element_id, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/path_element_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_path_element_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_path_element_id() directly.

    YANG Description: To identify the element in a path.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="path-element-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """path_element_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="path-element-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)""",
        })

    self.__path_element_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_path_element_id(self):
    self.__path_element_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="path-element-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=True)


  def _get_numbered_node_hop(self):
    """
    Getter method for numbered_node_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/numbered_node_hop (container)

    YANG Description: Numbered node route hop.
    """
    return self.__numbered_node_hop
      
  def _set_numbered_node_hop(self, v, load=False):
    """
    Setter method for numbered_node_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/numbered_node_hop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_numbered_node_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_numbered_node_hop() directly.

    YANG Description: Numbered node route hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=numbered_node_hop.numbered_node_hop, is_container='container', yang_name="numbered-node-hop", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """numbered_node_hop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=numbered_node_hop.numbered_node_hop, is_container='container', yang_name="numbered-node-hop", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__numbered_node_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_numbered_node_hop(self):
    self.__numbered_node_hop = YANGDynClass(base=numbered_node_hop.numbered_node_hop, is_container='container', yang_name="numbered-node-hop", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_numbered_link_hop(self):
    """
    Getter method for numbered_link_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/numbered_link_hop (container)

    YANG Description: Numbered link explicit route hop.
    """
    return self.__numbered_link_hop
      
  def _set_numbered_link_hop(self, v, load=False):
    """
    Setter method for numbered_link_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/numbered_link_hop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_numbered_link_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_numbered_link_hop() directly.

    YANG Description: Numbered link explicit route hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=numbered_link_hop.numbered_link_hop, is_container='container', yang_name="numbered-link-hop", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """numbered_link_hop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=numbered_link_hop.numbered_link_hop, is_container='container', yang_name="numbered-link-hop", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__numbered_link_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_numbered_link_hop(self):
    self.__numbered_link_hop = YANGDynClass(base=numbered_link_hop.numbered_link_hop, is_container='container', yang_name="numbered-link-hop", parent=self, choice=('type', 'numbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_unnumbered_link_hop(self):
    """
    Getter method for unnumbered_link_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/unnumbered_link_hop (container)

    YANG Description: Unnumbered link explicit route hop.
    """
    return self.__unnumbered_link_hop
      
  def _set_unnumbered_link_hop(self, v, load=False):
    """
    Setter method for unnumbered_link_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/unnumbered_link_hop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unnumbered_link_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unnumbered_link_hop() directly.

    YANG Description: Unnumbered link explicit route hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=unnumbered_link_hop.unnumbered_link_hop, is_container='container', yang_name="unnumbered-link-hop", parent=self, choice=('type', 'unnumbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unnumbered_link_hop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=unnumbered_link_hop.unnumbered_link_hop, is_container='container', yang_name="unnumbered-link-hop", parent=self, choice=('type', 'unnumbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__unnumbered_link_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unnumbered_link_hop(self):
    self.__unnumbered_link_hop = YANGDynClass(base=unnumbered_link_hop.unnumbered_link_hop, is_container='container', yang_name="unnumbered-link-hop", parent=self, choice=('type', 'unnumbered-link-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_as_number_hop(self):
    """
    Getter method for as_number_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/as_number_hop (container)

    YANG Description: AS explicit route hop.
    """
    return self.__as_number_hop
      
  def _set_as_number_hop(self, v, load=False):
    """
    Setter method for as_number_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/as_number_hop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_as_number_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_as_number_hop() directly.

    YANG Description: AS explicit route hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=as_number_hop.as_number_hop, is_container='container', yang_name="as-number-hop", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """as_number_hop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=as_number_hop.as_number_hop, is_container='container', yang_name="as-number-hop", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__as_number_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_as_number_hop(self):
    self.__as_number_hop = YANGDynClass(base=as_number_hop.as_number_hop, is_container='container', yang_name="as-number-hop", parent=self, choice=('type', 'as-number'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)


  def _get_label_hop(self):
    """
    Getter method for label_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/label_hop (container)

    YANG Description: Label hop type.
    """
    return self.__label_hop
      
  def _set_label_hop(self, v, load=False):
    """
    Setter method for label_hop, mapped from YANG variable /networks/te/templates/link_template/te_link_attributes/underlay/primary_path/path_element/label_hop (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label_hop() directly.

    YANG Description: Label hop type.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=label_hop.label_hop, is_container='container', yang_name="label-hop", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label_hop must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=label_hop.label_hop, is_container='container', yang_name="label-hop", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)""",
        })

    self.__label_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label_hop(self):
    self.__label_hop = YANGDynClass(base=label_hop.label_hop, is_container='container', yang_name="label-hop", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=True)

  path_element_id = __builtin__.property(_get_path_element_id, _set_path_element_id)
  numbered_node_hop = __builtin__.property(_get_numbered_node_hop, _set_numbered_node_hop)
  numbered_link_hop = __builtin__.property(_get_numbered_link_hop, _set_numbered_link_hop)
  unnumbered_link_hop = __builtin__.property(_get_unnumbered_link_hop, _set_unnumbered_link_hop)
  as_number_hop = __builtin__.property(_get_as_number_hop, _set_as_number_hop)
  label_hop = __builtin__.property(_get_label_hop, _set_label_hop)

  __choices__ = {'type': {'numbered-node-hop': ['numbered_node_hop'], 'numbered-link-hop': ['numbered_link_hop'], 'unnumbered-link-hop': ['unnumbered_link_hop'], 'as-number': ['as_number_hop'], 'label': ['label_hop']}}
  _pyangbind_elements = OrderedDict([('path_element_id', path_element_id), ('numbered_node_hop', numbered_node_hop), ('numbered_link_hop', numbered_link_hop), ('unnumbered_link_hop', unnumbered_link_hop), ('as_number_hop', as_number_hop), ('label_hop', label_hop), ])


