
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from typing import Optional, Union
from uuid import UUID, uuid4, uuid5
from common.proto.context_pb2 import DeviceId


NAMESPACE_TFS = UUID('200e3a1f-2223-534f-a100-758e29c37f40')

def get_uuid_from_string(str_uuid_or_name : Union[str, UUID], prefix_for_name : Optional[str] = None) -> str:
    # if UUID given, assume it is already a valid UUID
    if isinstance(str_uuid_or_name, UUID): return str_uuid_or_name
    if not isinstance(str_uuid_or_name, str):
        MSG = 'Parameter({:s}) cannot be used to produce a UUID'
        raise Exception(MSG.format(str(repr(str_uuid_or_name))))
    try:
        # try to parse as UUID
        return str(UUID(str_uuid_or_name))
    except: # pylint: disable=bare-except
        # produce a UUID within TFS namespace from parameter
        if prefix_for_name is not None:
            str_uuid_or_name = '{:s}/{:s}'.format(prefix_for_name, str_uuid_or_name)
        return str(uuid5(NAMESPACE_TFS, str_uuid_or_name))


def opticalconfig_get_uuid ( device_id: DeviceId) -> str : 
    device_uuid = device_id.device_uuid.uuid
    if (len(device_uuid)>0):
        return get_uuid_from_string(f"{device_uuid}_opticalconfig")

    raise InvalidArgumentsException([
        ('DeviceId ', device_id),
       
    ], extra_details=['device_id is required to produce a OpticalConfig UUID'])