# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class supporting_tunnel_termination_point(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/supporting-tunnel-termination-point. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Identifies the TTPs on which this TTP depends.
  """
  __slots__ = ('_path_helper', '_extmethods', '__node_ref','__tunnel_tp_ref',)

  _yang_name = 'supporting-tunnel-termination-point'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__node_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:uri', is_config=True)
    self.__tunnel_tp_ref = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="tunnel-tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'supporting-tunnel-termination-point']

  def _get_node_ref(self):
    """
    Getter method for node_ref, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/supporting_tunnel_termination_point/node_ref (inet:uri)

    YANG Description: This leaf identifies the node in which the supporting
TTP is present.
This node is either the supporting node or a node in
an underlay topology.
    """
    return self.__node_ref
      
  def _set_node_ref(self, v, load=False):
    """
    Setter method for node_ref, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/supporting_tunnel_termination_point/node_ref (inet:uri)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node_ref() directly.

    YANG Description: This leaf identifies the node in which the supporting
TTP is present.
This node is either the supporting node or a node in
an underlay topology.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:uri', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node_ref must be of a type compatible with inet:uri""",
          'defined-type': "inet:uri",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:uri', is_config=True)""",
        })

    self.__node_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node_ref(self):
    self.__node_ref = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="node-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:uri', is_config=True)


  def _get_tunnel_tp_ref(self):
    """
    Getter method for tunnel_tp_ref, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/supporting_tunnel_termination_point/tunnel_tp_ref (binary)

    YANG Description: Reference to a TTP that is in either the supporting node
or a node in an underlay topology.
    """
    return self.__tunnel_tp_ref
      
  def _set_tunnel_tp_ref(self, v, load=False):
    """
    Setter method for tunnel_tp_ref, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/supporting_tunnel_termination_point/tunnel_tp_ref (binary)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tunnel_tp_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tunnel_tp_ref() directly.

    YANG Description: Reference to a TTP that is in either the supporting node
or a node in an underlay topology.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBinary, is_leaf=True, yang_name="tunnel-tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tunnel_tp_ref must be of a type compatible with binary""",
          'defined-type': "binary",
          'generated-type': """YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="tunnel-tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)""",
        })

    self.__tunnel_tp_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tunnel_tp_ref(self):
    self.__tunnel_tp_ref = YANGDynClass(base=YANGBinary, is_leaf=True, yang_name="tunnel-tp-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='binary', is_config=True)

  node_ref = __builtin__.property(_get_node_ref, _set_node_ref)
  tunnel_tp_ref = __builtin__.property(_get_tunnel_tp_ref, _set_tunnel_tp_ref)


  _pyangbind_elements = OrderedDict([('node_ref', node_ref), ('tunnel_tp_ref', tunnel_tp_ref), ])


