# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import te_label
class label_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry/connectivity-matrices/connectivity-matrix/path-properties/path-route-objects/path-route-object/label-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Label hop type.
  """
  __slots__ = ('_path_helper', '_extmethods', '__te_label',)

  _yang_name = 'label-hop'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__te_label = YANGDynClass(base=te_label.te_label, is_container='container', yang_name="te-label", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry', 'connectivity-matrices', 'connectivity-matrix', 'path-properties', 'path-route-objects', 'path-route-object', 'label-hop']

  def _get_te_label(self):
    """
    Getter method for te_label, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_properties/path_route_objects/path_route_object/label_hop/te_label (container)

    YANG Description: Container that specifies the TE label.  The choices can
be augmented for specific data-plane technologies.
    """
    return self.__te_label
      
  def _set_te_label(self, v, load=False):
    """
    Setter method for te_label, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices/connectivity_matrix/path_properties/path_route_objects/path_route_object/label_hop/te_label (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_te_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_te_label() directly.

    YANG Description: Container that specifies the TE label.  The choices can
be augmented for specific data-plane technologies.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=te_label.te_label, is_container='container', yang_name="te-label", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """te_label must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=te_label.te_label, is_container='container', yang_name="te-label", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__te_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_te_label(self):
    self.__te_label = YANGDynClass(base=te_label.te_label, is_container='container', yang_name="te-label", parent=self, choice=('type', 'label'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  te_label = __builtin__.property(_get_te_label)

  __choices__ = {'type': {'label': ['te_label']}}
  _pyangbind_elements = OrderedDict([('te_label', te_label), ])


