# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging, os, sys, time
from typing import Dict, Tuple
os.environ['DEVICE_EMULATED_ONLY'] = 'YES'
from device.service.drivers.gnmi_openconfig.GnmiOpenConfigDriver import GnmiOpenConfigDriver # pylint: disable=wrong-import-position
#from device.service.driver_api._Driver import (
#    RESOURCE_ENDPOINTS, RESOURCE_INTERFACES, RESOURCE_NETWORK_INSTANCES, RESOURCE_ROUTING_POLICIES, RESOURCE_SERVICES
#)

logging.basicConfig(level=logging.DEBUG)
LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

# +---+---------------------------+--------------+---------------------------------+-------+---------+--------------------+--------------+
# | # |           Name            | Container ID |              Image              | Kind  |  State  |    IPv4 Address    | IPv6 Address |
# +---+---------------------------+--------------+---------------------------------+-------+---------+--------------------+--------------+
# | 1 | clab-tfs-scenario-client1 | a8d48ec3265a | ghcr.io/hellt/network-multitool | linux | running | 172.100.100.201/24 | N/A          |
# | 2 | clab-tfs-scenario-client2 | fc88436d2b32 | ghcr.io/hellt/network-multitool | linux | running | 172.100.100.202/24 | N/A          |
# | 3 | clab-tfs-scenario-srl1    | b995b9bdadda | ghcr.io/nokia/srlinux           | srl   | running | 172.100.100.101/24 | N/A          |
# | 4 | clab-tfs-scenario-srl2    | aacfc38cc376 | ghcr.io/nokia/srlinux           | srl   | running | 172.100.100.102/24 | N/A          |
# +---+---------------------------+--------------+---------------------------------+-------+---------+--------------------+--------------+

def interface(if_name, sif_index, ipv4_address, ipv4_prefix, enabled) -> Tuple[str, Dict]:
    str_path = '/interface[{:s}]'.format(if_name)
    str_data = {'name': if_name, 'enabled': enabled, 'sub_if_index': sif_index, 'sub_if_enabled': enabled,
                'sub_if_ipv4_enabled': enabled, 'sub_if_ipv4_address': ipv4_address, 'sub_if_ipv4_prefix': ipv4_prefix}
    return str_path, str_data

def network_instance(ni_name, ni_type) -> Tuple[str, Dict]:
    str_path = '/network_instance[{:s}]'.format(ni_name)
    str_data = {'name': ni_name, 'type': ni_type}
    return str_path, str_data

def network_instance_static_route(ni_name, prefix, next_hop, next_hop_index=0) -> Tuple[str, Dict]:
    str_path = '/network_instance[{:s}]/static_route[{:s}]'.format(ni_name, prefix)
    str_data = {'name': ni_name, 'prefix': prefix, 'next_hop': next_hop, 'next_hop_index': next_hop_index}
    return str_path, str_data

def network_instance_interface(ni_name, if_name, sif_index) -> Tuple[str, Dict]:
    str_path = '/network_instance[{:s}]/interface[{:s}.{:d}]'.format(ni_name, if_name, sif_index)
    str_data = {'name': ni_name, 'if_name': if_name, 'sif_index': sif_index}
    return str_path, str_data

def main():
    driver_settings = {
        'protocol': 'gnmi',
        'username': 'admin',
        'password': 'NokiaSrl1!',
        'use_tls' : True,
    }
    driver = GnmiOpenConfigDriver('172.100.100.102', 57400, **driver_settings)
    driver.Connect()

    #resources_to_get = []
    #resources_to_get = [RESOURCE_ENDPOINTS]
    #resources_to_get = [RESOURCE_INTERFACES]
    #resources_to_get = [RESOURCE_NETWORK_INSTANCES]
    #resources_to_get = [RESOURCE_ROUTING_POLICIES]
    #resources_to_get = [RESOURCE_SERVICES]
    #LOGGER.info('resources_to_get = {:s}'.format(str(resources_to_get)))
    #results_getconfig = driver.GetConfig(resources_to_get)
    #LOGGER.info('results_getconfig = {:s}'.format(str(results_getconfig)))

    #resources_to_set = [
    #    network_instance('test-svc', 'L3VRF'),
    #
    #    interface('ethernet-1/1', 0, '172.16.0.1', 24, True),
    #    network_instance_interface('test-svc', 'ethernet-1/1', 0),
    #
    #    interface('ethernet-1/2', 0, '172.0.0.1', 24, True),
    #    network_instance_interface('test-svc', 'ethernet-1/2', 0),
    #
    #    network_instance_static_route('test-svc', '172.0.0.0/24', '172.16.0.2'),
    #    network_instance_static_route('test-svc', '172.2.0.0/24', '172.16.0.3'),
    #]
    #LOGGER.info('resources_to_set = {:s}'.format(str(resources_to_set)))
    #results_setconfig = driver.SetConfig(resources_to_set)
    #LOGGER.info('results_setconfig = {:s}'.format(str(results_setconfig)))

    resources_to_delete = [
        #network_instance_static_route('d35fc1d9', '172.0.0.0/24', '172.16.0.2'),
        #network_instance_static_route('d35fc1d9', '172.2.0.0/24', '172.16.0.3'),
    
        #network_instance_interface('d35fc1d9', 'ethernet-1/1', 0),
        #network_instance_interface('d35fc1d9', 'ethernet-1/2', 0),
    
        interface('ethernet-1/1', 0, '172.16.1.1', 24, True),
        interface('ethernet-1/2', 0, '172.0.0.2', 24, True),
    
        network_instance('20f66fb5', 'L3VRF'),
    ]
    LOGGER.info('resources_to_delete = {:s}'.format(str(resources_to_delete)))
    results_deleteconfig = driver.DeleteConfig(resources_to_delete)
    LOGGER.info('results_deleteconfig = {:s}'.format(str(results_deleteconfig)))

    time.sleep(1)

    driver.Disconnect()
    return 0

if __name__ == '__main__':
    sys.exit(main())
