
from common.proto.context_pb2 import LinkId
from common.method_wrappers.ServiceExceptions import InvalidArgumentsException
from ._Builder import get_uuid_from_string, get_uuid_random

optical_detail_sp="Optical_link_detail"
def opticaldetail_get_uuid(
    link_id : LinkId,allow_random=False
) -> str:
    link_uuid = link_id.link_uuid.uuid

    if len(link_uuid) > 0:
        str_uuid=f"{link_uuid}{optical_detail_sp}"
        return get_uuid_from_string(str_uuid)
  
    if allow_random: return get_uuid_random()

    raise InvalidArgumentsException([
        ('link_id.link_uuid.uuid', link_uuid),

    ], extra_details=['At least one is required to produce a Optical Link Detail UUID'])
