# Copyright 2022-2024 ETSI OSG/SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from flask import jsonify
import requests


logging.basicConfig(level=logging.DEBUG)
LOGGER = logging.getLogger()
BASE_URL = 'http://10.1.7.197/camara/qod/v0'

def test_create_profile():
    BASE_URL = 'http://10.1.7.197/camara/qod/v0'
    qos_profile_data={  
                      "name": "QCI_2_voice",
                      "description": "QoS profile for video streaming",
                      "status": "ACTIVE",
                      "targetMinUpstreamRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "maxUpstreamRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "maxUpstreamBurstRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "targetMinDownstreamRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "maxDownstreamRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "maxDownstreamBurstRate": {
                        "value": 10,
                        "unit": "bps"
                      },
                      "minDuration": {
                        "value": 12,
                        "unit": "Minutes"
                      },
                      "maxDuration": {
                        "value": 12,
                        "unit": "Minutes"
                      },
                      "priority": 20,
                      "packetDelayBudget": {
                        "value": 12,
                        "unit": "Minutes"
                      },
                      "jitter": {
                        "value": 12,
                        "unit": "Minutes"
                      },
                      "packetErrorLossRate": 3
                    }

    post_response = requests.post(f'{BASE_URL}/profiles', json=qos_profile_data).json()
    id=post_response['qos_profile_id']
    get_response = requests.get(f'{BASE_URL}/profiles/{id}').json()
    assert post_response['qos_profile_id'] == get_response['qos_profile_id']
    assert post_response['jitter'] == get_response['jitter']
    assert post_response['maxDownstreamBurstRate'] == get_response['maxDownstreamBurstRate']
    assert post_response['maxDownstreamRate'] == get_response['maxDownstreamRate']
    assert post_response['maxUpstreamBurstRate'] == get_response['maxUpstreamBurstRate']
    assert post_response['maxUpstreamRate'] == get_response['maxUpstreamRate']
    assert post_response['minDuration'] == get_response['minDuration']
    assert post_response['name'] == get_response['name']
    assert post_response['packetDelayBudget'] == get_response['packetDelayBudget']
    assert post_response['packetErrorLossRate'] == get_response['packetErrorLossRate']
    assert post_response['priority'] == get_response['priority']
    assert post_response['status'] == get_response['status']
    assert post_response['targetMinDownstreamRate'] == get_response['targetMinDownstreamRate']
    assert post_response['targetMinUpstreamRate'] == get_response['targetMinUpstreamRate']
 #assert response.status_code == 200, f"Failed to retrieve profile with status code {response.status_code}"

#def test_update_profile():
#    qos_profile_id = '1b4689d8-02a4-4a6c-bd0a-18ffecc1a336'      
#    qos_profile_data = {
#  "qos_profile_id": "1b4689d8-02a4-4a6c-bd0a-18ffecc1a336",
#  "name": "Updated Name",
#  "description": "Updated Description",
#  "status": "ACTIVE",
#  "targetMinUpstreamRate": {
#    "value": 20,
#    "unit": "bps"
#  },
#  "maxUpstreamRate": {
#    "value": 50,
#    "unit": "bps"
#  },
#  "maxUpstreamBurstRate": {
#    "value": 60,
#    "unit": "bps"
#  },
#  "targetMinDownstreamRate": {
#    "value": 30,
#    "unit": "bps"
#  },
#  "maxDownstreamRate": {
#    "value": 100,
#    "unit": "bps"
#  },
#  "maxDownstreamBurstRate": {
#    "value": 70,
#    "unit": "bps"
#  },
#  "minDuration": {
#    "value": 15,
#    "unit": "Minutes"
#  },
#  "maxDuration": {
#    "value": 25,
#    "unit": "Minutes"
#  },
#  "priority": 15,
#  "packetDelayBudget": {
#    "value": 10,
#    "unit": "Minutes"
#  },
#  "jitter": {
#    "value": 10,
#    "unit": "Minutes"
#  },
#  "packetErrorLossRate": 1
#}
#
#    response = requests.put(f'{BASE_URL}/profiles/{qos_profile_id}', json=qos_profile_data) 
#
#def test_delete_profile_by_id():
#    qos_profile_id = 'adcbc52e-85e1-42e2-aa33-b6d022798fb3' 
#    response = requests.delete(f'{BASE_URL}/profiles/{qos_profile_id}')

import logging
from flask import jsonify
import requests

logging.basicConfig(level=logging.DEBUG)
LOGGER = logging.getLogger()

# Define the base URL for the API
BASE_URL = 'http://10.1.7.197/camara/qod/v0'

def test_create_profile():
    # Define the QoS profile data
    qos_profile_data = {  
        "name": "QCI_2_voice",
        "description": "QoS profile for video streaming",
        "status": "ACTIVE",
        "targetMinUpstreamRate": {"value": 10, "unit": "bps"},
        "maxUpstreamRate": {"value": 10, "unit": "bps"},
        "maxUpstreamBurstRate": {"value": 10, "unit": "bps"},
        "targetMinDownstreamRate": {"value": 10, "unit": "bps"},
        "maxDownstreamRate": {"value": 10, "unit": "bps"},
        "maxDownstreamBurstRate": {"value": 10, "unit": "bps"},
        "minDuration": {"value": 12, "unit": "Minutes"},
        "maxDuration": {"value": 12, "unit": "Minutes"},
        "priority": 20,
        "packetDelayBudget": {"value": 12, "unit": "Minutes"},
        "jitter": {"value": 12, "unit": "Minutes"},
        "packetErrorLossRate": 3
    }

    # Test profile creation
    post_response = requests.post(f'{BASE_URL}/profiles', json=qos_profile_data).json()
    id = post_response['qos_profile_id']

    # Test profile retrieval
    get_response = requests.get(f'{BASE_URL}/profiles/{id}').json()
    
    # Assertions to check if post and get responses match
    assert post_response['qos_profile_id'] == get_response['qos_profile_id']
    assert post_response['jitter'] == get_response['jitter']
    assert post_response['maxDownstreamBurstRate'] == get_response['maxDownstreamBurstRate']
    assert post_response['maxDownstreamRate'] == get_response['maxDownstreamRate']
    assert post_response['maxUpstreamBurstRate'] == get_response['maxUpstreamBurstRate']
    assert post_response['maxUpstreamRate'] == get_response['maxUpstreamRate']
    assert post_response['minDuration'] == get_response['minDuration']
    assert post_response['name'] == get_response['name']
    assert post_response['packetDelayBudget'] == get_response['packetDelayBudget']
    assert post_response['packetErrorLossRate'] == get_response['packetErrorLossRate']
    assert post_response['priority'] == get_response['priority']
    assert post_response['status'] == get_response['status']
    assert post_response['targetMinDownstreamRate'] == get_response['targetMinDownstreamRate']
    assert post_response['targetMinUpstreamRate'] == get_response['targetMinUpstreamRate']

def test_get_constraints():
    # Replace with actual qos_profile_id you want to test with
    qos_profile_id = "contraints" 
    start_timestamp = 1726063284.25332
    duration = 86400

    # Send GET request to fetch constraints
    response = requests.get(f'{BASE_URL}/profiles/constraints', params={
        "qos_profile_id": qos_profile_id,
        "start_timestamp": start_timestamp,
        "duration": duration
    })
    
    # Convert response to JSON and add error checking
    if response.status_code == 200:
        constraints = response.json()
        LOGGER.debug(f"Constraints retrieved: {constraints}")
        
        # Additional assertions for constraints
        assert len(constraints) > 0, "Expected at least one constraint"
        first_constraint = constraints[0]
        assert "constraint_type" in first_constraint, "Constraint type missing in response"
    else:
        LOGGER.error(f"Failed to fetch constraints: Status code {response.status_code}")
