#!/bin/bash

PROJECTDIR=`pwd`

cd $PROJECTDIR/src
RCFILE=$PROJECTDIR/coverage/.coveragerc
COVERAGEFILE=$PROJECTDIR/coverage/.coverage

# Set the name of the Kubernetes namespace to deploy to.
K8S_NAMESPACE="ofc22"
K8S_NODENAME="kubernetes-master"

export CONTEXTSERVICE_SERVICE_HOST=$(kubectl get node $K8S_NODENAME -o 'jsonpath={.status.addresses[?(@.type=="InternalIP")].address}')
export CONTEXTSERVICE_SERVICE_PORT_GRPC=$(kubectl get service contextservice-public --namespace $K8S_NAMESPACE -o 'jsonpath={.spec.ports[?(@.port==1010)].nodePort}')
export DEVICESERVICE_SERVICE_HOST=$(kubectl get node $K8S_NODENAME -o 'jsonpath={.status.addresses[?(@.type=="InternalIP")].address}')
export DEVICESERVICE_SERVICE_PORT_GRPC=$(kubectl get service deviceservice-public --namespace $K8S_NAMESPACE -o 'jsonpath={.spec.ports[?(@.port==2020)].nodePort}')
export COMPUTESERVICE_SERVICE_HOST=$(kubectl get node $K8S_NODENAME -o 'jsonpath={.status.addresses[?(@.type=="InternalIP")].address}')
export COMPUTESERVICE_SERVICE_PORT_HTTP=$(kubectl get service computeservice-public --namespace $K8S_NAMESPACE -o 'jsonpath={.spec.ports[?(@.port==8080)].nodePort}')

# Run integration tests and analyze coverage of code at same time

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    tests/ofc22/tests/test_functional_delete_service.py
