import logging, pytest
from opticalattackmitigator.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD
from opticalattackmitigator.client.OpticalAttackMitigatorClient import OpticalAttackMitigatorClient
from opticalattackmitigator.service.OpticalAttackMitigatorService import OpticalAttackMitigatorService
from opticalattackmitigator.proto.optical_attack_mitigator_pb2 import AttackDescription, AttackResponse

port = 10000 + GRPC_SERVICE_PORT # avoid privileged ports

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def optical_attack_mitigator_service():
    _service = OpticalAttackMitigatorService(
        port=port, max_workers=GRPC_MAX_WORKERS, grace_period=GRPC_GRACE_PERIOD)
    _service.start()
    yield _service
    _service.stop()

@pytest.fixture(scope='session')
def optical_attack_mitigator_client(optical_attack_mitigator_service):
    _client = OpticalAttackMitigatorClient(address='127.0.0.1', port=port)
    yield _client
    _client.close()

def test_call_service(optical_attack_mitigator_client: OpticalAttackMitigatorClient):
    request = AttackDescription()
    optical_attack_mitigator_client.NotifyAttack(request)
