import copy
from typing import Dict, Optional

def json_topology_id(topology_uuid : str, context_id : Optional[Dict] = None):
    result = {'topology_uuid': {'uuid': topology_uuid}}
    if context_id is not None: result['context_id'] = copy.deepcopy(context_id)
    return result

def json_topology(topology_uuid : str, context_id : Optional[Dict] = None):
    return {
        'topology_id': json_topology_id(topology_uuid, context_id=context_id),
        'device_ids' : [],
        'link_ids'   : [],
    }
