package eu.teraflow.automation.device.model;

import eu.teraflow.automation.context.model.Event;

public class DeviceEvent {

    private final Event event;
    private final String deviceId;

    public DeviceEvent(String deviceId, Event event) {
        this.event = event;
        this.deviceId = deviceId;
    }

    public Event getEvent() {
        return event;
    }

    public String getDeviceId() {
        return deviceId;
    }

    @Override
    public String toString() {
        return String.format("%s[%s, %s]", getClass().getSimpleName(), deviceId, event.toString());
    }
}
