package eu.teraflow.automation.context.model;

public class Event {

    // TODO convert double to meaningful timestamp type
    private final double timestamp;
    private final EventTypeEnum eventType;

    public Event(double timestamp, EventTypeEnum eventType) {
        this.timestamp = timestamp;
        this.eventType = eventType;
    }

    public double getTimestamp() {
        return timestamp;
    }

    public EventTypeEnum getEventTypeEnum() {
        return eventType;
    }

    @Override
    public String toString() {
        return String.format(
                "%s{timestamp=\"%f\", eventType=\"%s\"}",
                getClass().getSimpleName(), timestamp, eventType.toString());
    }
}
