# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import grpc
from typing import Optional
from common.proto.context_pb2 import Connection, ConnectionId, Device, DeviceId, Service, ServiceId
from context.client.ContextClient import ContextClient

def get_connection(context_client : ContextClient, connection_id : ConnectionId) -> Optional[Connection]:
    try:
        connection : Connection = context_client.GetConnection(connection_id)
        return connection
    except grpc.RpcError as e:
        if e.code() != grpc.StatusCode.NOT_FOUND: raise # pylint: disable=no-member
        return None

def get_device(context_client : ContextClient, device_id : DeviceId) -> Optional[Device]:
    try:
        device : Device = context_client.GetDevice(device_id)
        return device
    except grpc.RpcError as e:
        if e.code() != grpc.StatusCode.NOT_FOUND: raise # pylint: disable=no-member
        return None

def get_service(context_client : ContextClient, service_id : ServiceId) -> Optional[Service]:
    try:
        service : Service = context_client.GetService(service_id)
        return service
    except grpc.RpcError as e:
        if e.code() != grpc.StatusCode.NOT_FOUND: raise # pylint: disable=no-member
        return None
